package com.xinxincaravan.caravan.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.xinxincaravan.caravan.vehicle.biz.CampsiteBiz;
import com.xinxincaravan.caravan.vehicle.common.BaseController;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.BranchCompany;
import com.xinxincaravan.caravan.vehicle.entity.Campsite;
import com.xinxincaravan.caravan.vehicle.feign.UserFeign;
import com.xinxincaravan.caravan.vehicle.feign.dto.UserDTO;
import com.xinxincaravan.caravan.vehicle.vo.CampsiteVo;
import com.xinxincaravan.caravan.vehicle.vo.PageDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.http.HTTPBinding;
import java.util.List;

@RestController
@RequestMapping("/campsite")
@Slf4j
@IgnoreClientToken
public class CampsiteController extends BaseController<CampsiteBiz> {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @RequestMapping(value ="/page",method = RequestMethod.GET)
    public RestResponse<PageDataVo<Campsite>> page(@RequestParam Integer page, @RequestParam Integer limit,
                                                   @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                   @RequestParam(required = false) Integer addrTown) {
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, userDTO));
    }

    @IgnoreUserToken
    @RequestMapping(value = "/allPage", method = RequestMethod.GET)
    public RestResponse<PageDataVo<Campsite>> allPage(@RequestParam Integer page, @RequestParam Integer limit,
                                                           @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                           @RequestParam(required = false) Integer addrTown) {
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, null));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<Campsite>> getAll() {
        return RestResponse.data(baseBiz.getAll());
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    public RestResponse<Campsite> get(@PathVariable Integer id) {
        return RestResponse.data(baseBiz.getById(id));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody CampsiteVo campsiteVo) {
        return RestResponse.data(baseBiz.add(campsiteVo));
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.uploadCompanyPic(file);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse update(@RequestBody Campsite campsite) {
        baseBiz.update(campsite);
        return RestResponse.sucResponse();
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse del(@PathVariable Integer id) {
        baseBiz.del(id);
        return RestResponse.sucResponse();
    }
    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("importExcel")
    public RestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return baseBiz.importExcel(multipartfile,request);
    }

}
