package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum AccompanyingItemStatus {
    NORMAL(1,"正常"),//这一类型不存在db中，只是用于查询所有国家
    DELETED(2,"已删除"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(AccompanyingItemStatus constantType : AccompanyingItemStatus.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    AccompanyingItemStatus(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
