package com.github.wxiaoqi.security.admin.feign;


import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "ace-admin")
public interface UserFeign {
    @RequestMapping(value = "/public/userinfo-by-token")
    public ObjectRestResponse<UserDTO> userinfoByToken(@RequestParam("token") String token);
    @RequestMapping(value = "/public/app/userinfo-by-token")
    public ObjectRestResponse<AppUserDTO> userDetailByToken(@RequestParam("token") String token);


    /**
     *status:0-判断是否认证过,1-认证成功后修改用户认证状态
     *userId:用户登录时的id,必须
     *idNumber:证件号,修改认证状态是必须有
     */
    @RequestMapping(value = "/api/app/user/authentication", method = RequestMethod.POST)
    public ObjectRestResponse authentication( @RequestParam(value="userId")Integer  userId,
                                              @RequestParam(value="idNumber")String idNumber,
                                              @RequestParam(value="status")Integer  status);
    @RequestMapping(value = "/member/levels", method = RequestMethod.GET)
    public List<BaseUserMemberLevel> levels();



}
