package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum MemberEnum {
    NONE(0, "非会员"),
    NORMAL(1, "普通会员"),
    GOLD(2, "黄金会员"),
    DIAMOND(3, "钻石会员"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    MemberEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}