package com.xxfc.platform.vehicle.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.VehicleDispatchInfo;
import com.xxfc.platform.vehicle.mapper.VehicleDispatchInfoMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleDispatchInfoDto;
import com.xxfc.platform.vehicle.pojo.vo.VehiclDispatchRecordVo;
import com.xxfc.platform.vehicle.pojo.vo.VehicleDispatchInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *车辆调度
 */
@Service
@Slf4j
public class VehicleDispatchInfoBiz extends BaseBiz<VehicleDispatchInfoMapper,VehicleDispatchInfo> {

     @Autowired
    UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    VehicleBiz vehicleBiz;


    //提交调度申请表单
    public ObjectRestResponse addDisspatchInfo(VehicleDispatchInfo vehicleDispatchInfo){
        if (vehicleDispatchInfo==null){
            return ObjectRestResponse.paramIsEmpty();
        }
        insertSelective(vehicleDispatchInfo);
        return  ObjectRestResponse.succ();
    }

    //获取申请列表
    public  ObjectRestResponse getInfoList(VehicleDispatchInfoDto dispatchInfoDto, HttpServletRequest request){
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        List<VehicleDispatchInfoVo> list=new ArrayList<>();
        Integer pageSize=dispatchInfoDto.getPage()==null?1:dispatchInfoDto.getPage();
        Integer pageNo=dispatchInfoDto.getPage()==null?10:dispatchInfoDto.getLimit();
        if (userDTO != null) {
            List<Integer> companyList=new ArrayList<>();
            if (userDTO.getDataAll() == 1) {
                String zoneId= dispatchInfoDto.getZoneId();
                String companyId=dispatchInfoDto.getCompanyId();
                companyList=vehicleBiz.dataCompany(zoneId,companyId);
            }else {
                companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
            }
             dispatchInfoDto.setCompanyList(companyList);
             list=mapper.getInfoList(dispatchInfoDto);
             if (list.size()>0){
                 for (VehicleDispatchInfoVo vehicleDispatchInfoVo:list){
                     String recordIds=vehicleDispatchInfoVo.getRecordIds();
                     if (StringUtils.isBlank(recordIds)){
                         continue;
                     }
                     String[] ids=recordIds.split(",");
                     List<VehiclDispatchRecordVo> recordVos= mapper.getRecordList(Arrays.asList(ids));
                     if (recordVos.size()>0) {
                         vehicleDispatchInfoVo.setDispatchRecords(recordVos);
                     }
                 }
             }
        }
        PageHelper.startPage(pageNo,pageSize);
        PageInfo<VehicleDispatchInfoVo> pageInfo = new PageInfo<>(list);
        return  ObjectRestResponse.succ(PageDataVO.pageInfo(pageInfo));
    }









}
