package com.xxfc.platform.order.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Administrator
 */

@Data
@ApiModel(value = "月订单统计实体")
public class OrderStatistics {

    /**
     * 月成交总金额
     */
    @ApiModelProperty(value = "月成交总金额")
    private BigDecimal totalGmv;

    /**
     * 月押金总额
     */
    @ApiModelProperty(value = "月押金总额")
    private BigDecimal totalSecurityDeposit;

    /**
     * 月退还押金总额
     */
    @ApiModelProperty(value = "月退还押金总额")
    private BigDecimal totalRefundSecurityDeposit;

    /**
     * 月赔偿总额
     */
    @ApiModelProperty(value = "月赔偿总额")
    private BigDecimal totalCompensation;

    /**
     * 月违章总额
     */
    @ApiModelProperty(value = "月违章总额")
    private BigDecimal totalForfeit;

    /**
     * 月取消订单扣款总额
     */
    @ApiModelProperty(value = "月取消订单扣款总额")
    private BigDecimal totalPenalSum;

    /**
     * 月延期扣款总额
     */
    @ApiModelProperty(value = "月延期扣款总额")
    private BigDecimal totalPostpone;
}
