package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.universal.entity.Invoice;
import com.xxfc.platform.universal.entity.vo.InvoiceVo;
import com.xxfc.platform.universal.service.InvoiceBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 发票接口
 * @Auther: Administrator
 * @Date: 2019/12/31 09:57
 * @Description:
 */
@RestController
@RequestMapping("/invoice")
@Slf4j
public class InvoiceController extends BaseController<InvoiceBiz, Invoice> {


    /**
     * 根据开票代码获取税号
     * @param code
     * @return
     */
    @GetMapping("/dutyParagraph")
    public ObjectRestResponse getDutyParagraphByCode(@RequestParam("code")String code){
        String dutyParagraph = baseBiz.getDutyParagraphByCode(code);
        return ObjectRestResponse.succ(dutyParagraph);
    }

    /**
     * 模糊查询获取公司全名和开票代码
     * @param name
     * @return
     */
    @GetMapping("/corporateName")
    public ObjectRestResponse corporateName(@RequestParam("name")String name){
        List<Map<String, String>> mapList = baseBiz.corporateName(name);
        return ObjectRestResponse.succ(mapList);
    }

    /**
     * 开票接口
     * @param invoiceVo
     * @return
     * @throws Exception
     */
    @PostMapping("/invoicing")
    public ObjectRestResponse invoicing(@RequestBody InvoiceVo invoiceVo)  {

        String invoicing = null;
        try {
            invoicing = baseBiz.Invoicing(invoiceVo);
            return ObjectRestResponse.succ(invoicing);
        } catch (Exception e) {
         log.error("开票错误信息={}",e);
         return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"开票失败");
        }

    }

    /**
     * 查询开票结果
     * @param invoiceSerialNum
     * @return
     */
    @GetMapping("/result")
    public ObjectRestResponse invoiceResult(@RequestParam("invoiceSerialNum")String invoiceSerialNum){
        List<Map<String,Object>> result=  baseBiz.invoiceResult(invoiceSerialNum);
        return ObjectRestResponse.succ(result);
    }
}
