package com.xxfc.platform.universal.service.impl;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.universal.constant.enumerate.FileTypeEnum;
import com.xxfc.platform.universal.service.UploadZipService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Slf4j
@Service
public class UploadZipServiceImpl implements UploadZipService {

    @Value("${universal.uploadPath}")
    private String uploadPath ;
    @Value("${universal.url}")
    private String xx_url ;

    private static final String APK_SUFFIX=".apk";
    private static final String APK_NAME="xxfc.apk";
    private static final String JPG=".jpg";
    private static final String PNG=".png";

    @Override
    public ObjectRestResponse uploadPictureZip(MultipartFile file, String password) throws IOException {
        if (Objects.isNull(file)) {
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"请上传压缩文件!");
        }

        String fileContentType = file.getContentType();
        //将压缩包保存在指定路径
        String packFilePath = uploadPath + File.separator + file.getName();
        if (FileTypeEnum.FILE_TYPE_ZIP.type.equals(fileContentType)||FileTypeEnum.FILE_TYPE_X_ZIP.type.equals(fileContentType)) {
            //zip解压缩处理
            packFilePath += FileTypeEnum.FILE_TYPE_ZIP.fileStufix;
        } else {
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"上传的压缩包格式不正确,仅支持zip压缩文件!");
        }
        File fi = new File(packFilePath);
        try {
            file.transferTo(fi);
        } catch (IOException e) {
            log.error("zip file save to " + uploadPath + " error", e.getMessage(), e);
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"保存压缩文件到:" + uploadPath + " 失败!");
        }
            //zip压缩包
        return   unPackZip(fi, password, uploadPath);

    }

    public ObjectRestResponse unPackZip(File file, String password, String destPath) throws IOException  {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                 destPath =destPath+File.separator+ entry.getName();
                File dir = new File(destPath);
                dir.mkdir();
            }else {

            }


        }

       return null;
    }
}
