package com.xxfc.platform.uccn.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.VModelDetailVO;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/vehicleModel/app/unauth")
@Slf4j
@IgnoreClientToken
@Api(tags = "房车车型", value = "房车车型")
public class VehicleModelController extends CommonBaseController {

    @Autowired
    VehicleFeign vehicleFeign;

    /**
     * 车型详情
     *
     * @param name
     * @return
     */
    @ApiOperation("车型详情")
    @RequestMapping(value = "/detail/{name}", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<VModelDetailVO> detail(@PathVariable("name") @ApiParam("车型名称") String name) {
        ObjectRestResponse<VModelDetailVO> objectRestResponse = vehicleFeign.detailByParam(BeanUtil.beanToMap(new VehicleModel(){{
            setName(name);
        }}, false, true));
        objectRestResponse.getData().setUccnCataList(initUccnCataCollect(objectRestResponse.getData().getConfig()));
        return objectRestResponse;
    }

    /**
     * 车型列表查
     *
     * @param vmqc 条件
     * @return
     */
    @ApiOperation("车型列表")
    @GetMapping(value = "/findVehicleModelPage")
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<VehicleModelVo>> findVehicleModelPageUnauthfind(VehicleModelQueryCondition vmqc) {
        vmqc.setNotInIds("67");
        ObjectRestResponse<PageDataVO<VehicleModelVo>> objectRestResponse = vehicleFeign.findVehicleModelPageUnauthfind(vmqc);
        PageDataVO<VehicleModelVo> pageDataVOs = objectRestResponse.getData();
        pageDataVOs.getData().forEach( v -> {
            v.setUccnCataList(initUccnCataCollect(v.getConfig()));
        });
        return objectRestResponse;
    }

    private List<VehiclePlatCata> initUccnCataCollect(String modelConfig) {
        List<VehiclePlatCata> vehiclePlatCataList = vehicleFeign.getCatasByIds(modelConfig).getData();
        int[] array = StrUtil.splitToInt("14,7,11", ",");
        return vehiclePlatCataList.parallelStream()
                .filter(v1 -> {return ArrayUtil.contains(array, v1.getParentId());})
                .sorted(Comparator.comparing(VehiclePlatCata::getParentId, (x, y) -> {
            int xx = 0,yy = 0;
            for(int i = 0; i < array.length; i++) {
                if(x == array[i]) {
                    xx = i;
                }else if(y == array[i]) {
                    yy = i;
                }
            }
            return (xx - yy);
        })).collect(Collectors.toList());
    }
}
