package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderUserLicenseBiz;
import com.xxfc.platform.order.entity.OrderUserLicense;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/orderUserLicense")
@Api(value = "订单驾驶员信息")
public class OrderUserLicenseController {

    @Autowired
    OrderUserLicenseBiz orderUserLicenseBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加订单驾驶员信息")
    public ObjectRestResponse add(OrderUserLicense orderUserLicense) {
        return orderUserLicenseBiz.add(orderUserLicense);
    }

    @GetMapping(value = "/getUserLicenseById")
    @ApiOperation(value = "根据id获取驾驶人信息")
    public ObjectRestResponse getUserLicenseById(String userLicenseIds) {
        return orderUserLicenseBiz.selectByIds(userLicenseIds);
    }

    @GetMapping(value = "/selectByUserIdCard")
    @ApiOperation(value = "根据身份证号获取驾驶人信息")
    public ObjectRestResponse  selectByUserIdCard(String licenseIdCard) {
        return orderUserLicenseBiz.selectByUserIdCard(licenseIdCard);
    }

}
