package com.xxfc.platform.order.service;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.OrderCostDetailBiz;
import com.xxfc.platform.order.biz.OrderMemberDetailBiz;
import com.xxfc.platform.order.biz.OrderTemplateBiz;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.pojo.order.MemberBO;
import com.xxfc.platform.order.pojo.price.OrderPriceVO;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.log4j.Log4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

@Service
@Log4j
public class OrderMemberService extends AbstractOrderHandle<OrderMemberDetailBiz, MemberBO> {

    @Autowired
    TourFeign tourFeign;

    @Autowired
    VehicleFeign vehicleFeign;


    private static Integer IS_CHILD = 1;
    private static Integer LEVEL_DEFAULT = 0;
    private static Integer NUMBER_ZERO = 0;

    @Autowired
    OrderCostDetailBiz orderCostDetailBiz;

    @Autowired
    OrderTemplateBiz orderTemplateBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    UserFeign userFeign;

    @Autowired
    public HttpServletRequest request;

    @PostConstruct
    public void init(){
        this.orderTypeEnum = OrderTypeEnum.MEMBER;
    }

    public AppUserDTO getUserInfo(){
        return  userFeign.userDetailByToken(userAuthConfig.getToken(request)).getData();
    }

    @Override
    public void initDetail(MemberBO bo) {
        super.initDetail(bo);
        BaseUserMemberLevel buml = userFeign.level(bo.getMemberLevel());
        if(!bo.getMemberLevelId().equals(buml.getId())) {
            throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE, new HashSet<String>(){{
                add("MemberLevelId 和 MemberLevel不对称");
            }});
        }
        bo.setBaseUserMemberLevel(buml);
        bo.setRentFreeNum(buml.getNumber());
        bo.setRebate(buml.getDiscount());
    }

    @Override
    public void handleDetail(MemberBO bo) {
        //设置订单状态为3
        bo.getOrder().setStatus(OrderStatusEnum.ORDER_UNPAY.getCode());
        //设置订单图片
        bo.getOrder().setPicture(bo.getBaseUserMemberLevel().getIcon());
        //设置订单名称
        bo.getOrder().setName(bo.getBaseUserMemberLevel().getName());

        super.handleDetail(bo);

        //发送定时取消订单(30分钟)
        rabbitProduct.sendDelayMessage(bo.getOrder(), 1000L * 60 * 30);
    }

    @Override
    public void handleCalculate(MemberBO bo) {
        OrderPriceVO tpv = calculatePrice(bo);
        BeanUtil.copyProperties(tpv, bo.getOrder());
        BeanUtil.copyProperties(tpv, bo);
    }

    @Override
    public OrderPriceVO calculatePrice(MemberBO detail) {
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal goodsAmount = BigDecimal.ZERO;
        BigDecimal realAmount = BigDecimal.ZERO;

            //商品价格
        goodsAmount = goodsAmount.add(detail.getBaseUserMemberLevel().getPrice());
            //订单总价格
        orderAmount = orderAmount.add(goodsAmount);
            //真实价格
        realAmount = realAmount.add(orderAmount);

            //生成订单明细
        OrderPriceVO opv = new OrderPriceVO();
        opv.setOrderAmount(orderAmount);
        opv.setGoodsAmount(goodsAmount);
        opv.setRealAmount(realAmount);

        return opv;
    }
}
