package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 活动（活动列表）
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Data
@Table(name = "activity_list")
public class ActivityList implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  活动名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "活动名称")
    private String name;
	
	    /**
     *  活动开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "活动开始时间")
    private Long startTime;
	
	    /**
     *  活动结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "活动结束时间")
    private Long endTime;
	
	    /**
     *  人数限制 -1--无限制
     */
    @Column(name = "num_limit")
	@ApiModelProperty(value = "人数限制 -1--无限制")
    private Integer numLimit;
	
	    /**
     *  已经参与人数
     */
    @Column(name = "has_join_num")
	@ApiModelProperty(value = "已经参与人数")
    private Integer hasJoinNum;
	
	    /**
     *  当前状态 1--显示在活动页 2--隐藏
     */
    @Column(name = "status")
	@ApiModelProperty(value = "当前状态 1--显示在活动页 2--隐藏")
    private Integer status;
	
	    /**
     *  排序
     */
    @Column(name = "sort")
	@ApiModelProperty(value = "排序")
    private Integer sort;
	
	    /**
     *  活动图片
     */
    @Column(name = "picture")
	@ApiModelProperty(value = "活动图片")
    private Integer picture;
	

}
