package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.MyWalletBiz;
import com.github.wxiaoqi.security.admin.dto.WalletFindDTO;
import com.github.wxiaoqi.security.admin.vo.WalletPageVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/17 14:11
 */
@RestController
@RequestMapping("/wallet/admin")
public class MyWalletAdminController {

     @Autowired
     private MyWalletBiz myWalletBiz;

     @ApiOperation("分页查询用户钱包")
     @GetMapping("/page")
     public ObjectRestResponse<PageDataVO<WalletPageVo>> listWalletWithPage(WalletFindDTO walletFindDTO){
          PageDataVO<WalletPageVo> walletPage = myWalletBiz.listWalletWithPage(walletFindDTO);
         return ObjectRestResponse.succ(walletPage);
     }

     @PutMapping("/forbidden")
     public ObjectRestResponse<Void>  forbiddenWallet(@RequestParam(value = "id") Integer id,
                                  @RequestParam(value = "state") Integer state){
          myWalletBiz.forbiddenWalletById(id,state);
         return ObjectRestResponse.succ();
     }
}
