package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.uccn.biz.RandomListBiz;
import com.xxfc.platform.uccn.dto.RandomListDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/random/list")
public class RandomListController {
    @Autowired
    RandomListBiz randomListBiz;

    @GetMapping("/app/unauth/get")
    public ObjectRestResponse getRandomList(RandomListDto randomListDto) {
        if(randomListDto == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        return randomListBiz.getRandomList(randomListDto.getType(), randomListDto.getNumber(), randomListDto.getLocation());
    }

}
