package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.order.entity.DailyTravelOrderStatistics;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.mapper.DailyTravelOrderStatisticsMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 每日旅游订单统计
 *
 * @author Administrator
 */
@Service
@Slf4j
public class DailyTravelOrderStatisticsBiz extends BaseBiz<DailyTravelOrderStatisticsMapper, DailyTravelOrderStatistics> {
    @Value("${order.day}")
    private Integer day;

     @Transactional(rollbackFor = Exception.class)
    public boolean StatisticsOfTravelOrders() {
        try {

            ArrayList<DailyTravelOrderStatistics> objects = new ArrayList<>();
            List<DailyTravelOrderStatistics> travelGmv = mapper.getTravelGmv(day);
            objects.addAll(travelGmv);
            List<DailyTravelOrderStatistics> travelPenalSum = mapper.getTravelPenalSum(day);
            objects.addAll(travelPenalSum);
            insertByList(objects);

            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
    }

    private void insertByList(ArrayList<DailyTravelOrderStatistics> objects) throws Exception {

        if (CollectionUtils.isNotEmpty(objects)) {
            HashMap<Integer, DailyTravelOrderStatistics> map = new HashMap<>();
            for (DailyTravelOrderStatistics object : objects) {

                DailyTravelOrderStatistics statistics = map.get(object.getBranchCompanyId());
                if (statistics == null) {
                    statistics = new DailyTravelOrderStatistics();
                    map.put(object.getBranchCompanyId(), statistics);
                }

                BeanUtil.copyProperties(object, statistics, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));

            }
            String oneDay = map.entrySet().parallelStream().map(Map.Entry::getValue).collect(Collectors.toList()).get(0).getOneDay();

            if (StringUtils.isBlank(oneDay)) {
                throw new BaseException();
            }
            Example exa= new Example(DailyTravelOrderStatistics.class);
            exa.createCriteria().andEqualTo("oneDay",oneDay);
            List<DailyTravelOrderStatistics> statistics= selectByExample(exa);
            if (CollectionUtils.isEmpty(statistics)){
                for (Map.Entry<Integer, DailyTravelOrderStatistics> entry : map.entrySet()) {
                    insertSelectiveRe(entry.getValue());
                }
            }else {
                log.error("今日已统计车辆订单,请不要重复统计!");
            }

//
//            for (Map.Entry<Integer, DailyTravelOrderStatistics> e : map.entrySet()) {
//                insertSelectiveRe(e.getValue());
//            }
        }
    }


    @Override
    public int insertSelectiveRe(DailyTravelOrderStatistics entity) {
        entity.setCrtTime(new Date());
        return mapper.insertSelective(entity);
    }

    public OrderStatistics findAll(Integer branchCompanyId) {
        return mapper.monthOrderTotal(branchCompanyId);
    }
}
