package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.vehicle.biz.VehicleCataBiz;
import com.xxfc.platform.vehicle.biz.VehiclePlatCataBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.common.VehicleBaseController;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import com.xxfc.platform.vehicle.pojo.Cascade;
import com.xxfc.platform.vehicle.pojo.CataVo;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePlatCataVo;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/backstage/cata")
@Slf4j
@IgnoreClientToken

public class BgVehicleCataController extends VehicleBaseController<VehiclePlatCataBiz> {

    @Autowired
    VehicleCataBiz vehicleCataBiz;


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public RestResponse update(@RequestBody CataVo cataVo) throws Exception {
        return baseBiz.update(cataVo);
    }
    @RequestMapping(value = "/app/all", method = RequestMethod.POST)
    public RestResponse test() throws Exception {
        AppUserDTO userDTO =getUserInfo();

        return RestResponse.data(userDTO);
    }

    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.POST)
    @IgnoreUserToken
    public RestResponse all() throws Exception {
        return RestResponse.data(baseBiz.findTypeTree());
    }

    @RequestMapping(value = "/bind", method = RequestMethod.POST)
    public RestResponse bind(
            @RequestParam(value = "ids",defaultValue = "") String  ids,
            @RequestParam(value = "modelId",defaultValue = "0") Integer  modelId
    ) throws Exception {
        return vehicleCataBiz.updateCataByModel(ids,modelId);
    }


    /**
     * 根据父类id获取子标签
     * @param parentId
     * @return
     */
    @GetMapping(value = "/add/fingCatasByParentId/{parentId}")
    public ObjectRestResponse<List<VehiclePlatCata>> fingCatasByParentId(@PathVariable("parentId") Integer parentId ){
        return   baseBiz.fingCatasByParentId(parentId);

    }

    /**
     * 查询一个一级标签及其子标签
     * @param id
     * @return
     */
    @GetMapping(value = "/findCascade")
    public ObjectRestResponse findCascade(Integer id){
        return baseBiz.findCascade(id);

    }


    /**
     * 分页或不分页,获取一级标签及其子标签
     * #@param dto.page 当前页
     * #@param dto.limit 每页条数
     * #@param dto.sort 分类 0-标签管理页面,1-增加车辆页面
     * @return
     */
    @GetMapping(value = "/operation/getCascades")
    public ObjectRestResponse getCascades(PageDTO dto){
        return baseBiz.getCascades(dto.getPage(), dto.getLimit(), dto.getSort(), dto.getGoodsType(), dto.getName());
    }

    /**
     * 分页或不分页,获取一级标签及其子标签
     * #@param dto.page 当前页
     * #@param dto.limit 每页条数
     * #@param dto.sort 分类 0-标签管理页面,1-增加车辆页面
     * @return
     */
    @GetMapping(value = "/business/getCascades")
    public ObjectRestResponse getBusinessCascades(PageDTO dto){
        dto.setSort(1);
        return baseBiz.getCascades(dto.getPage(), dto.getLimit(), dto.getSort(), dto.getGoodsType(), dto.getName());
    }

    @Data
    public static class PageDTO extends PageParam {
        Integer sort;
        Integer goodsType;
        String name;
    }


    /**
     * 级联添加
     * @param cascade
     * @return
     */
    @PostMapping(value = "/add/addCascade/")
    @Transactional
    public ObjectRestResponse addCascade(@RequestBody Cascade<VehiclePlatCata> cascade){

            return baseBiz.addCascade(cascade);


    }


    /**
     * 修改和增加一二级标签
     * @param cas
     * @return
     */
    @PostMapping("/operation/updateAndAdd")
    public ObjectRestResponse save(@RequestBody Cascade<VehiclePlatCata> cas){

        return  baseBiz.updateAndAdd(cas);
    }


    /**
     * 修改标签排序
     * @param id
     * @param rank
     * @return
     */
    @PutMapping("/add/updateParentRank/{id}/{rank}")
    public ObjectRestResponse updateParentRank(@PathVariable("id")  Integer id,@PathVariable("rank") Integer rank){

        return  baseBiz.updateParentRank(id,rank);
    }


    /**
     * 查询当前车型拥有的标签
     * @param ids
     * @return
     */
    @GetMapping("/add/getCatasByIds/{ids}")
    public ObjectRestResponse<List<VehiclePlatCata>> getCatasByIds(@PathVariable String ids){
        return  baseBiz.getCatasByIds(ids);
    }

    /**
     * 删除一级标签及其子标签
     * #@param vehiclePlatCata.id 标签id
     * @return
     */
    @DeleteMapping("/operation/deleteCascadeById")
    public ObjectRestResponse deleteCascadeById(@RequestBody VehiclePlatCata vehiclePlatCata){
        return  baseBiz.deleteCascadeById(vehiclePlatCata.getId());
    }


    /**
     * 修改客户端查询条件
     * @param id
     * @param startUsing
     * @return
     */
    @PutMapping("/add/setStartUsingById/{id}/{startUsing}")
    public ObjectRestResponse setStartUsingById(@PathVariable("id") Integer id,@PathVariable("startUsing") Integer startUsing){
        return  baseBiz.setStartUsingById(id,startUsing);
    }

    /**
     * 修改单选还是多选
     * @param id
     * @param isMore
     * @return
     */
    @PutMapping("/add/setIsMore/{id}/{isMore}")
    public ObjectRestResponse setIsMore (@PathVariable("id") Integer id,@PathVariable("isMore") Integer isMore){
        return  baseBiz.setIsore(id,isMore);
    }

    /**
     * 根据类型id查询分类
     * @param type
     * @return
     */
    @GetMapping("/app/unauth/types")
    public ObjectRestResponse<List<VehiclePlatCataVo>> findVehiclePlatCate(@RequestParam(value = "type",required = false,defaultValue = "7") Integer type){
        List<VehiclePlatCataVo> category = baseBiz.findVehicleCategoryByParentId(type);
        return ObjectRestResponse.succ(category);
    }


}
