package com.xxfc.platform.vehicle.rest.admin;


import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.biz.VehicleExtensionBiz;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.dto.VehicleExtensionFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import com.xxfc.platform.vehicle.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/vehicle")
@Api(tags = {"商品申请"})
public class AdminVehicleController extends BaseController<VehicleBiz>{

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleExtensionBiz extensionBiz;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }



    @GetMapping("shop/selectList")
    @ApiModelProperty("店铺商品列表")
    public  ObjectRestResponse shopSelectList(VehicleFindDTO vehicleFindDTO) {
        setPowerData(vehicleFindDTO);
        return  baseBiz.selectList(vehicleFindDTO);
    }


    @GetMapping("selectList")
    @ApiModelProperty("运营商品列表")
    public  ObjectRestResponse selectList(VehicleFindDTO vehicleFindDTO) {
        return  baseBiz.selectList(vehicleFindDTO);
    }



    @PostMapping("updVehicle")
    @ApiModelProperty("更新商品信息")
    public  ObjectRestResponse updVehicle(@RequestBody Vehicle vehicle) {
        baseBiz.updateSelectiveById(vehicle);
        return ObjectRestResponse.succ();
    }

    @PostMapping("/unauth/app/updVehicleFeign")
    @IgnoreUserToken
    @ApiModelProperty("更新商品信息Feign")
    public ObjectRestResponse updVehicleFeign(@RequestBody Vehicle vehicle) {
        baseBiz.updateSelectiveById(vehicle);
        return ObjectRestResponse.succ();
    }

    @PostMapping("delVehicle")
    @ApiModelProperty("更新商品信息")
    public  ObjectRestResponse delVehicle(@RequestBody Vehicle vehicle) {
        vehicle.setIsDel(1);
        baseBiz.updateSelectiveById(vehicle);
        return ObjectRestResponse.succ();
    }


    @GetMapping("info")
    @ApiModelProperty("商品详情")
    public  ObjectRestResponse info(VehicleFindDTO vehicleFindDTO) {
        return  ObjectRestResponse.succ(baseBiz.info(vehicleFindDTO));
    }



    @GetMapping("tree")
    @ApiModelProperty("扩展详情")
    public  ObjectRestResponse tree(VehicleExtensionFindDTO extensionFindDTO) {
        return  ObjectRestResponse.succ(extensionBiz.getTreeByPlatCata(extensionFindDTO));
    }








}
