package com.xxfc.platform.order.pojo.dto;


import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 门店收支明细DTO
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 14:53
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderDetailDTO {


    public static final Integer  PAY  = 1; //支付
    public static final Integer  CANEL = 2; //取消
    public static final Integer  ADVANCE = 3; //提前还车
    public static final Integer  DELAY = 4; //延迟还车
    public static final Integer  FINISH = 5; //正常完成




    @ApiModelProperty("租车订单详情")
    private OrderRentVehicleDetail rentVehicleDetail;


    @ApiModelProperty("订单类型")
    private  Integer  orderType;


    @ApiModelProperty("订单号")
    private  String orderNo;



    @ApiModelProperty("用户id")
    private  Integer userId;



    @ApiModelProperty("订单id")
    private  Integer orderId;



    @ApiModelProperty("订单id")
    private  Integer  goodsDepositType;



    @ApiModelProperty("订单状态")
    private  Integer orderStatus = PAY;




    @ApiModelProperty("商品实付金额")
    private BigDecimal goodsAmount =BigDecimal.ZERO;


    @ApiModelProperty("消费金额")
    private BigDecimal orderAmount =BigDecimal.ZERO;



    @ApiModelProperty("不计免赔费")
    private BigDecimal damageSafeAmount =BigDecimal.ZERO;


    @ApiModelProperty("其他费用-延迟用车不记免赔")
    private BigDecimal damageSafeAmount2 =BigDecimal.ZERO;



    @ApiModelProperty("定损费")
    private BigDecimal lossSpecifiedAmount =BigDecimal.ZERO;


    @ApiModelProperty("违章费")
    private BigDecimal breakRulesRegulation =BigDecimal.ZERO;


    @ApiModelProperty("违约金")
    private BigDecimal violateAmount =BigDecimal.ZERO;


    @ApiModelProperty("更换还车公司费用")
    private BigDecimal chageAmount =BigDecimal.ZERO;


    @ApiModelProperty("分账金额")
    private BigDecimal acceptAmount;

    public  BigDecimal getAcceptAmount(){
        return  goodsAmount.subtract(orderAmount).subtract(violateAmount);
    }



}
