package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BranchCompanyBiz;
import com.github.wxiaoqi.security.admin.biz.BranchCompanyGiveBiz;
import com.github.wxiaoqi.security.admin.dto.CompanySearchDTO;
import com.github.wxiaoqi.security.admin.entity.BranchCompany;
import com.github.wxiaoqi.security.admin.entity.BranchCompanyGive;
import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.admin.vo.CompanySearchVO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/branchCompany")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"商家"})
public class AppBranchCompanyController extends BaseController<BranchCompanyBiz> {


    @Autowired
    BranchCompanyGiveBiz branchCompanyGiveBiz;





    @GetMapping("getHotCompany")
    @ApiModelProperty("获取热门商家")
    public  ObjectRestResponse getHotCompany(@RequestParam("page") Integer page,
                                             @RequestParam("limit") Integer limit) {
     return ObjectRestResponse.succ(baseBiz.getHotCompany(page,limit));
    }



    @GetMapping("app/unauth/selectList")
    @ApiModelProperty("店铺列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectList(CompanySearchDTO companySearchDTO) {
        return ObjectRestResponse.succ( baseBiz.search(companySearchDTO));
    }


    @GetMapping("app/unauth/info")
    @ApiModelProperty("店铺信息")
    @IgnoreUserToken
    public  ObjectRestResponse info(CompanySearchDTO companySearchDTO) {
        if (companySearchDTO.getId() == null || companySearchDTO.getId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                companySearchDTO.setId(companyIds.get(0));
            }
        }
        List<CompanySearchVO> list = baseBiz.getList(companySearchDTO);
        if (list.size() == 0){
            throw  new BaseException("店铺不存在", ResultCode.FAILED_CODE);
        }
        doBrowse(companySearchDTO);
        return ObjectRestResponse.succ(list.get(0));
    }

    @PostMapping("addOrUpd")
    @ApiModelProperty("店铺更新")
    public  ObjectRestResponse addOrUpd(@RequestBody BranchCompany branchCompany) {
        return baseBiz.addOrUpd(branchCompany);
    }


    @GetMapping("checkGive")
    @ApiModelProperty("检查点赞")
    public  ObjectRestResponse checkGive(BranchCompanyGive branchCompanyGive) {
        branchCompanyGive.setUserId(getCurrentUserIdInt());
        BranchCompanyGive userCompanyGive = branchCompanyGiveBiz.getUserCompanyGive(branchCompanyGive);
        boolean flag=false;
        if (userCompanyGive != null ){
            flag=true;
        }
        return ObjectRestResponse.succ(flag);
    }


    @PostMapping("doGive")
    @ApiModelProperty("点赞")
    public  ObjectRestResponse doGive(@RequestBody  BranchCompanyGive branchCompanyGive) {
        branchCompanyGive.setUserId(getCurrentUserIdInt());
        branchCompanyGiveBiz.addOrUpdGive(branchCompanyGive);
        return ObjectRestResponse.succ();
    }


    @PostMapping("canelGive")
    @ApiModelProperty("取消点赞")
    public  ObjectRestResponse canelGive(@RequestBody BranchCompanyGive branchCompanyGive) {
        branchCompanyGive.setUserId(getCurrentUserIdInt());
        branchCompanyGive.setIsDel(1);
        branchCompanyGiveBiz.addOrUpdGive(branchCompanyGive);
        return ObjectRestResponse.succ();
    }


    public  void  doBrowse(CompanySearchDTO companySearchDTO){
        try {
            Integer isBrowse = companySearchDTO.getIsBrowse() == null ? 0 :companySearchDTO.getIsBrowse();
            Integer companyId = companySearchDTO.getId() == null ? 0 : companySearchDTO.getId();
            if (isBrowse == 1 && companyId > 0){
                BranchCompany branchCompany1 = baseBiz.selectById(companyId);
                if (branchCompany1 != null){
                    BranchCompany branchCompany=new BranchCompany();
                    branchCompany.setId(companyId);
                    branchCompany.setBrowseNum(branchCompany1.getBrowseNum()+1);
                    baseBiz.addOrUpd(branchCompany);
                }
            }
        }catch (Exception e){

        }

    }

}
