package com.github.wxiaoqi.security.admin.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;


/**
 * 用户会员
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 19:38:56
 */
@Data
public class UserMemberVo {

	
	    /**
    *  主键id
   */
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  会员编号
     */
	@ApiModelProperty(value = "会员编号")
    private String memberNo;
	
	    /**
     *  会员等级
     */
	@ApiModelProperty(value = "会员等级")
    private Integer memberLevel;
	
	    /**
     *  卡内余额
     */
	@ApiModelProperty(value = "卡内余额")
    private Integer cardLeave;
	
	/**
     *  0:未支付 1：绑定 2:解绑
     */
	@ApiModelProperty(value = "0:未支付 1：绑定 2:解绑")
    private Integer isBind;
	
	    /**
     *  赠送总天数
     */
	@ApiModelProperty(value = "赠送总天数")
    private Integer totalNumber;
	
	/**
     *  剩余天数
     */
	@ApiModelProperty(value = "剩余天数")
    private Integer rentFreeDays;

	/**
	 *  会员消费次数
	 */
	@ApiModelProperty(value = "会员消费次数")
	private Integer payCount;

	/**
	 *  购买会员次数
	 */
	@ApiModelProperty(value = "购买会员次数")
	private Integer buyCount;

	/**
	 *  下单锁住天数
	 */
	@ApiModelProperty(value = "下单锁住天数")
	private Integer lockDays;


	//折扣
	@ApiModelProperty(value = "折扣")
	private Integer discount;
	
	    /**
     *  有效期;0代表永久
     */
	@ApiModelProperty(value = "有效期;0代表永久")
    private Long validTime;
	
	    /**
     *  创建时间
     */
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	/**
     *  是否删除；0-正常；1-删除
     */
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;

	@ApiModelProperty("会员名")
	private String memberName;

	@Column(name = "member_type")
	private Integer memberType;
}
