import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/order/baseOrder/getOrderList',
    method: 'get',
		params:query
  });
}

/**
 * 获取所有分公司
 */
export function getAllBranchCompany() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  });
}
//根据大区Id获取分公司列表
export function getAllBranchCompanyByZoneId(query) {
  return fetch({
    url: '/vehicle/branchCompany/app/unauth/getByZone',
    method: 'get',
		params:query
  });
}

export function getOrderVehicleCrosstown(query) {
  return fetch({
    url: '/api/order/orderVehicle/getByOrderId',
    method: 'get',
		params:query
  });
}

/**
 * 根据id获取一条违章查询记录
 * @param query
 */
export function getOneIllegalRow(id) {
  return fetch({
    url: '/api/order/orderViolation/getOne/' + id,
    method: 'get'
  });
}

/**
 * 保存违章记录
 * @param query
 * {price:图片地址(多个逗号分割)
price:退款总金额
detailId:租车订单id
}
 */
export function saveOrderViolation(params) {
  return fetch({
    url: '/api/order/orderViolation/saveOrderViolation',
    method: 'post',
    data: params
  });
}
