import fetch from 'utils/fetch';

export function getAppVersions(query) {
  return fetch({
    url: '/api/app/version/background/getAppVersions',
    method: 'post',
    data:query
  });
}

export function insertAppVersion(obj) {
  return fetch({
    url: '/api/app/version/background/add',
    method: 'post',
    data:obj
  });
}

export function updateAppVersion(obj) {
  return fetch({
    url: '/api/app/version/background/update',
    method: 'put',
    data:obj
  });
}


export function removeAppVersion(id) {
  return fetch({
    url: '/api/app/version/background/remove/'+id,
    method: 'post',
  });
}


export function getAppVersion(id) {
  return fetch({
    url: '/api/app/version/background/getAppVersion/'+id,
    method: 'get',
  });
}

export function uploadInstallationPackage(id) {
  return fetch({
    url: '/api/app/version/upload/installationPackage',
    method: 'post',
  });
}
