import fetch from 'utils/fetch';

export function getAppVersions(query) {
  return fetch({
    url: '/api/app/version/background/getAppVersions',
    method: 'post',
    data:query
  });
}

export function insertAppVersion(obj) {
  return fetch({
    url: '/api/app/version/background/add',
    method: 'post',
    data:obj
  });
}

export function updateAppVersion(obj) {
  return fetch({
    url: '/api/app/version/background/update',
    method: 'put',
    data:obj
  });
}


export function removeAppVersion(id) {
  return fetch({
    url: '/api/app/version/background/remove/'+id,
    method: 'delete',
  });
}


export function uploadInstallationPackage(id) {
  return fetch({
    url: '/api/app/version/upload/installationPackage',
    method: 'post',
  });
}

export function getOne(id) {
  return fetch({
    url: '/api/app/version/background/getAppVersion/'+id,
    method: 'get',
  });
}


/**
 * 标识管理列表
 */
export function getMarkList(query) {
  return fetch({
    url: '/api/app/version/mark/findAllByQuery',
    method: 'get',
    params: query
  });
}

/**
 * 新增标识
 */
export function appMarkVersionAdd(query) {
  return fetch({
    url: '/api/app/version/mark/appMarkVersionAdd',
    method: 'post',
    data: query
  });
}

/**
 * 编辑/删除标识
 */
export function appMarkVersionUpdate(query) {
  return fetch({
    url: '/api/app/version/mark/updAppMark',
    method: 'post',
    data: query
  });
}

/**
 * 终端删选
 */
export function listMark(query) {
  return fetch({
    url: '/api/app/version/mark/find/listMark',
    method: 'get',
    params: query
  });
}

