import fetch from 'utils/fetch';

/**
 * 获取活动列表
 * @param query
 */
export function activityList(query) {
  return fetch({
    url: '/api/activity/management/activity/findAll',
    method: 'post',
    data: query
  });
}

/**
 * 获取弹窗管理列表某一条数据
 * @param query
 */
export function getObj(id) {
  return fetch({
    url: '/api/activity/management/getOne/'+id,
    method: 'Get'
  })
}

/**
 * 编辑某一条数据
 * @param query
 */
export function editObj(data) {
  return fetch({
    url: '/api/activity/management/update',
    method: 'put',
    data: data
  })
}