import fetch from 'utils/fetch';

//根据大区Id获取分公司列表
export function getAllBranchCompanyByZoneId(query) {
    return fetch({
      url: '/vehicle/branchCompany/app/unauth/getByZone',
      method: 'get',
          params:query
    });
  }

/**
 * 获取申请列表--申请列表
 * @param query
 */
export function getApplyList(query) {
    return fetch({
      url: '/api/app/admin/buy_vehicle/page',
      method: 'POST',
      data: query
    });
  }

  /**
 * 处理
 * @param query
 */
export function changeStatus(id) {
  return fetch({
    url: '/api/app/admin/buy_vehicle/status/' + id,
    method: 'POST',
  });
}

// 报名列表
export function applyList(params) {
  return fetch({
    url: 'api/activity/admin/activityLuckyDraw/page',
    method: 'POST',
    data: params
  });
}

// 报名列表导出
export function excel(query) {
  return fetch({
    url: 'api/activity/admin/activityLuckyDraw/export',
    method: 'post',
    data: query,
    responseType: 'blob'
  });
}

// 中奖列表
export function applyListWin(params) {
  return fetch({
    url: '/api/activity/admin/activityWinningRecord/page',
    method: 'POST',
    data: params
  });
}

// 中奖列表导出
export function excelWin(query) {
  return fetch({
    url: '/api/activity/admin/activityWinningRecord/export',
    method: 'post',
    data: query,
    responseType: 'blob'
  });
}

// 活动数据
export function applyListActive(params) {
  return fetch({
    url: '/api/activity/admin/activityAttendanceRecord/page',
    method: 'POST',
    data: params
  });
}

// 活动数据
export function excelActive(query) {
  return fetch({
    url: '/api/activity/admin/activityAttendanceRecord/export',
    method: 'post',
    data: query,
    responseType: 'blob'
  });
}

// 奖品设置
export function savePrize(query) {
  return fetch({
    url: '/api/activity/admin/activityPrize/save',
    method: 'post',
    data: query
  });
}

// 奖品详情
export function infoPrize(query) {
  return fetch({
    url: 'api/activity/admin/activityPrize/list',
    method: 'get',
    data: query
  });
}