import Vue from 'vue';
import Router from 'vue-router';

const _import = require('./_import_' + process.env.NODE_ENV);
// in development env not use Lazy Loading,because Lazy Loading large page will cause webpack hot update too slow.so only in production use Lazy Loading

Vue.use(Router);

/* layout */
import Layout from '../views/layout/Layout';

/**
 * icon : the icon show in the sidebar
 * hidden : if `hidden:true` will not show in the sidebar
 * redirect : if `redirect:noredirect` will no redirct in the levelbar
 * noDropdown : if `noDropdown:true` will has no submenu
 * meta : { role: ['admin'] }  will control the page role
 **/
export const constantRouterMap = [{
  path: '/login',
  component: _import('login/index'),
  hidden: true
},
{
  path: '/authredirect',
  component: _import('login/authredirect'),
  hidden: true
},
{
  path: '/map',
  component: _import('map'),
  name: '地图',
  hidden: true
},
{
  path: '/stockCrowd',
  component: _import('baseInfo/stockCrowd/stockCrowd'),
  name: '分公司入股',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/stockCrowdDetail',
  component: _import('baseInfo/stockCrowdDetail/index'),
  name: '入股申请',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/campsite',
  component: _import('baseInfo/campsite/campsite'),
  name: '营地',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/companyInfo',
  component: _import('baseInfo/companyInfo/index'),
  name: '公司信息',
  hidden: true
  // authority: 'companyInfo'
},
{
  path: '/companyDetail',
  component: _import('baseInfo/companyInfo/companyDetail'),
  name: '公司详情',
  hidden: true
  // authority: 'companyInfo'
},
{
  path: '/provinceMap',
  component: _import('baseInfo/companyInfo/provinceMap'),
  name: '省市分布',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/404',
  component: _import('error/404'),
  hidden: true
},
{
  path: '/401',
  component: _import('error/401'),
  hidden: true
},
  // {
  //   path: '/',
  //   component: Layout,
  //   redirect: '/dashboard',
  //   name: '首页',
  //   hidden: true,
  //   children: [{
  //     path: 'dashboard',
  //     component: _import('dashboard/index')
  //   }]
  // },

{
  path: '/',
  component: Layout,
  redirect: '/index',
  name: '首页',
  hidden: true,
  children: [{
    path: 'index',
    component: _import('index/index')
  }]
},
{
  path: '/introduction',
  component: Layout,
  redirect: '/introduction/index',
  icon: 'form',
  noDropdown: true,
  children: [{
    path: 'index',
    component: _import('introduction/index'),
    name: '简述'
  }]
}
]

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({
    y: 0
  }),
  routes: constantRouterMap
});

export const asyncRouterMap = [{
  path: '/baseManager',
  component: Layout,
  name: '基础配置管理',
  icon: 'setting',
  authority: 'baseManager',
  children: [{
    path: 'userManager',
    icon: 'fa-user',
    component: _import('admin/user/index'),
    name: '后台用户管理',
    authority: 'userManager'
  }, {
    path: 'appUserManager',
    icon: 'fa-user',
    component: _import('admin/appUser/index'),
    name: 'App用户管理',
    authority: 'appUserManager'
  }, {
    path: 'menuManager',
    icon: 'category',
    component: _import('admin/menu/index'),
    name: '菜单管理',
    authority: 'menuManager'
  }, {
    path: 'groupManager',
    icon: 'group_fill',
    component: _import('admin/group/index'),
    name: '角色权限管理',
    authority: 'groupManager'
  }, {
    path: 'groupTypeManager',
    icon: 'fa-users',
    component: _import('admin/groupType/index'),
    name: '角色类型管理',
    authority: 'groupTypeManager'
  }, {
    path: 'gateLogManager',
    icon: 'viewlist',
    component: _import('admin/gateLog/index'),
    name: '操作日志管理',
    authority: 'gateLogManager'
  }]
},
{
  path: '/authManager',
  component: Layout,
  name: '基础配置管理',
  icon: 'setting',
  authority: 'authManager',
  children: [{
    path: 'serviceManager',
    component: _import('auth/service/index'),
    name: '用户管理',
    authority: 'serviceManager'
  }]
},
{
  path: '/memberManager',
  component: Layout,
  name: '会员管理',
  icon: 'fn-user',
  authority: 'memberManager',
  children: [{
    path: 'memberInfo',
    component: _import('member/info/index'),
    authority: 'memberInfo'
  }]
},
{
  path: '/monitorManager',
  component: Layout,
  name: '监控模块管理',
  icon: 'setting',
  authority: 'monitorManager',
  children: [{
    path: 'serviceEurekaManager',
    component: _import('monitor/eureka/index'),
    name: 'Eureka注册中心',
    authority: 'serviceEurekaManager'
  }, {
    path: 'serviceMonitorManager',
    component: _import('monitor/service/index'),
    name: '服务状态监控',
    authority: 'serviceMonitorManager'
  }, {
    path: 'serviceZipkinManager',
    component: _import('monitor/zipkin/index'),
    name: '服务状态监控',
    authority: 'serviceZipkinManager'
  }]
}, {
  path: '/baseInfo',
  component: Layout,
  name: '基础信息',
  icon: 'fa-user',
  authority: 'baseInfo',
  children: [{
    path: 'branchCompany',
    component: _import('baseInfo/branchCompany/index'),
    name: '分公司管理',
    authority: 'branchCompany'
  },
  {
    path: 'campsite',
    component: _import('baseInfo/campsite/index'),
    name: '营地管理',
    authority: 'campsite'
  },
  {
    path: '/baseInfo/accompanyingItem',
    component: _import('vehicle/accompanyingItem/index'),
    name: '随行物品管理',
    authority: 'accompanyingItem'
  },
  {
    path: 'branchCompany/stock',
    component: _import('branchCompany/stock/index'),
    name: '分公司股权信息管理',
    authority: 'branchCompany/stock'
  },
  {
    path: 'branchCompany/stockApply',
    component: _import('branchCompany/stockApply/index'),
    name: '分公司股权信息管理',
    authority: 'branchCompany/stockApply'
  },
  {
    path: 'vehicleUpkeepItem',
    component: _import('vehicle/vehicleUpkeepItem/index'),
    name: '车辆保养项目管理',
    authority: 'vehicleUpkeepItem'
  },
  {
    path: 'generalSetting',
    component: _import('baseInfo/generalSetting'),
    name: '通用设置',
    authority: 'generalSetting'
  },
  {
    path: 'bannerSetting',
    component: _import('baseInfo/bannerSetting'),
    name: 'banner设置',
    authority: 'bannerSetting'
  }
  ]
},
{
  path: '/vehicleType',
  component: Layout,
  name: '车型管理',
  icon: 'setting',
  authority: 'vehicleType',
  children: [
    {
      path: 'vehicleTypeList',
      component: _import('vehicleType/index'),
      name: '车型列表',
      authority: 'vehicleTypeList'
    },
    {
      path: 'vehicleTypeLabel',
      component: _import('vehicleType/vehicleTypeLabel'),
      name: '车型标签设置',
      authority: 'vehicleTypeLabel'
    }
  ]
},
{
  path: '/campsiteManage',
  component: Layout,
  name: '营地管理',
  icon: 'setting',
  authority: 'campsiteManage',
  children: [
    {
      path: 'campsiteList',
      component: _import('campsiteManage/index'),
      name: '营地列表',
      authority: 'campsiteList'
    },
    {
      path: 'campsiteLabel',
      component: _import('campsiteManage/campsiteLabel'),
      name: '营地标签设置',
      authority: 'campsiteLabel'
    }
  ]
},
{
  path: '/vehicle',
  component: Layout,
  name: '车辆管理',
  icon: 'setting',
  authority: 'vehicle',
  children: [
    {
      path: 'vehicleInfo',
      component: _import('vehicle/vehicleInfo/index'),
      name: '车辆信息管理',
      authority: 'vehicleInfo'
    },
    {
      path: 'bookRecord',
      component: _import('vehicle/bookRecord/index'),
      name: '车辆申请管理',
      authority: 'bookRecord'
    },
    {
      path: 'bookingManagement',
      component: _import('vehicle/smallProgram/bookingManagement'),
      name: '小程序车辆申请管理',
      authority: 'bookingManagement'
    },
    {
      path: 'vehicleWarningMsg',
      component: _import('vehicle/vehicleWarningMsg/index'),
      name: '车辆预警消息',
      authority: 'vehicleWarningMsg'
    },
    {
      path: 'vehicleDepartureLog',
      component: _import('vehicle/vehicleDepartureLog/index'),
      name: '车辆出车记录',
      authority: 'vehicleDepartureLog'
    },
    {
      path: 'vehicleUpkeepLog',
      component: _import('vehicle/vehicleUpkeepLog/index'),
      name: '车辆保养记录',
      authority: 'vehicleUpkeepLog'
    },
    {
      path: 'vehicleSchedulManage',
      component: _import('vehicle/vehicleSchedulManage/index'),
      name: '车辆排班管理',
      authority: 'vehicleSchedulManage'
    },
    {
      path: 'vehicleRecords',
      component: _import('vehicle/vehicleSchedulManage/vehicleRecords'),
      name: '车辆排班记录',
      authority: 'vehicleRecords'
    },
    // {
    //   path: 'dispatchApply',
    //   component: _import('vehicle/dispatchApply/index'),
    //   name: '调度申请管理',
    //   authority: 'dispatchApply'
    // }
  ]
},
{
  path: '/tourManage',
  component: Layout,
  name: '旅行管理',
  icon: 'setting',
  authority: 'tourManage',
  children: [
    {
      path: 'tourList',
      component: _import('tourManage/index'),
      name: '旅行列表',
      authority: 'tourList'
    },
    {
      path: 'tourLabel',
      component: _import('tourManage/tourLabel'),
      name: '旅行标签设置',
      authority: 'tourLabel'
    }
  ]
},
{
  path: '/order',
  component: Layout,
  name: '订单管理',
  icon: 'setting',
  authority: 'order',
  children: [
    {
      path: 'rentVehicleInfo',
      component: _import('order/rentVehicleInfo/index'),
      name: '租车订单管理',
      authority: 'rentVehicleInfo'
    },
    {
      path: 'tourOrderInfo',
      component: _import('order/tourOrderInfo/index'),
      name: '旅游订单管理',
      authority: 'tourOrderInfo'
    },
    {
      path: 'memberOrderInfo',
      component: _import('order/memberOrderInfo/index'),
      name: '会员订单管理',
      authority: 'memberOrderInfo'
    }
  ]
},
{
  path: '/purseManage',
  component: Layout,
  name: '钱包管理',
  icon: 'setting',
  authority: 'purseManage',
  children: [
    {
      path: 'incomeOverview',
      component: _import('purseManage/incomeOverview'),
      name: '收益总览',
      authority: 'incomeOverview'
    },
    {
      path: 'gainRecord',
      component: _import('purseManage/gainRecord'),
      name: '收益记录',
      authority: 'gainRecord'
    },
    {
      path: 'commissionSettings',
      component: _import('purseManage/commissionSettings'),
      name: '佣金设置比例',
      authority: 'commissionSettings'
    },
    {
      path: 'discountRecord',
      component: _import('purseManage/discountRecord'),
      name: '提现记录',
      authority: 'discountRecord'
    }
  ]
},
{
  path: '/userManagement',
  component: Layout,
  name: '用户管理',
  icon: 'setting',
  authority: 'userManagement',
  children: [
    {
      path: 'userList',
      component: _import('userManagement/userList/index'),
      name: '用户列表',
      authority: 'userList'
    },
    {
      path: 'memberManagement',
      component: _import('userManagement/memberManagement/index'),
      name: '会员管理',
      authority: 'memberManagement'
    },
    {
      path: 'memberEnter',
      component: _import('userManagement/memberEnter'),
      name: '会员录入',
      authority: 'memberEnter'
    }
  ]
},
{
  path: '/appManagement',
  component: Layout,
  name: 'app管理',
  icon: 'setting',
  authority: 'appManagement',
  children: [
    {
      path: 'appVersion',
      component: _import('appManagement/appVersion/index'),
      name: 'app版本管理',
      authority: 'appVersion'
    },
    {
      path: 'modalManagement',
      component: _import('appManagement/modalManagement/index'),
      name: '首页弹窗管理',
      authority: 'modalManagement'
    },
    {
      path: 'selectedActivities',
      component: _import('appManagement/selectedActivities/index'),
      name: '首页精选活动',
      authority: 'selectedActivities'
    }
  ]
},
{
  path: '/cunponManagements',
  component: Layout,
  name: '优惠券管理',
  icon: 'setting',
  authority: 'cunponManagements',
  children: [
    {
      path: 'cunponManagement',
      component: _import('cunponManagements/cunponManagement'),
      name: '优惠券管理',
      authority: 'cunponManagement'
    },
    {
      path: 'conponList',
      component: _import('cunponManagements/conponList'),
      name: '优惠券列表',
      authority: 'conponList'
    }
  ]
},
{
  path: '/activityManagement',
  component: Layout,
  name: '活动管理',
  icon: 'setting',
  authority: 'activityManagement',
  children: [
    {
      path: 'activityList',
      component: _import('activityManagement/activityList'),
      name: '活动列表',
      authority: 'activityList'
    }
  ]
},
{
  path: '/applyManagements',
  component: Layout,
  name: '申请管理',
  icon: 'setting',
  authority: 'applyManagements',
  children: [
    {
      path: 'carApplyList',
      component: _import('applyManagements/carApplyList'),
      name: '购房车申请列表',
      authority: 'carApplyList'
    }
  ]
}
,
  {
    path: '/xxOfficialWebsite',
    component: Layout,
    name: '欣新房车官网管理',
    icon: 'setting',
    authority: 'xxOfficialWebsite',
    children: [
      {
        path: 'activityList',
        component: _import('xxOfficialWebsite/activityList'),
        name: '活动管理',
        authority: 'activityList'
      },
      {
        path: 'newsList',
        component: _import('xxOfficialWebsite/newsList'),
        name: '新闻管理',
        authority: 'newsList'
      },
      {
        path: 'bannerList',
        component: _import('xxOfficialWebsite/bannerList'),
        name: 'banner管理',
        authority: 'bannerList'
      },
      {
        path: 'seoList',
        component: _import('xxOfficialWebsite/seoList'),
        name: 'SEO管理',
        authority: 'seoList'
      }
    ]
  }
];
