import fetch from 'utils/fetch';

/**
 * 排班列表
 * @param query
 */
export function getVehiclePlanList(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/app/unauth/getVehiclePlanList',
    method: 'get',
    params: query
  });
}
/**
 * 根据订单号获取租车订单详情
 * @param query
 */
export function getVehicleOrderDetail(query) {
  return fetch({
    url: '/api/order/baseOrder/orderDetail',
    method: 'get',
    params: query
  });
}

/**
 * 同意
 * @param query
 */
export function agreeBook(bookRecordId) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/prove/' + bookRecordId,
    method: 'put'
  });
}

/**
 * 取消
 */
export function cancleBook(bookRecordId) {
  return fetch({
    url: '/vehicle/vehicleInfo/unbook/4employee/' + bookRecordId,
    method: 'delete'
  });
}

/**
 * 拒绝
 */
export function rejectBook(bookRecordId) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/reject/' + bookRecordId,
    method: 'put'
  });
}

/**
 * 安排用车
 */
export function bookPlan(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee',
    method: 'post',
    data: query
  });
}

/**
 * 排班记录
 */
export function getBookRecord(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/app/unauth/getBookRecord',
    method: 'get',
    params: query
  });
}
