import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/summit/activity/app/unauth/list',
    method: 'post',
    data: query
  })
}

export function update(query) {
  return fetch({
    url: '/api/summit/activity/update',
    method: 'put',
    data: query
  })
}


export function getOne(id) {
  return fetch({
    url: '/api/summit/activity/'+id,
    method: 'get'
  })
}


export function add(obj) {
  return fetch({
    url: '/api/summit/activity/add',
    method: 'post',
    data:obj
  })
}

export function activityIds() {
  return fetch({
    url: '/api/summit/imxr/ids',
    method: 'get'
  })
}

export function remove(id) {
  return fetch({
    url: '/api/summit/activity/remove/' + id,
    method: 'delete'
  })
}