import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/order/baseOrder/getOrderList',
    method: 'get',
		params:query
  });
}

/**
 * 获取所有分公司
 */
export function getAllBranchCompany() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  });
}
//根据大区Id获取分公司列表
export function getAllBranchCompanyByZoneId(query) {
  return fetch({
    url: '/vehicle/branchCompany/app/unauth/getByZone',
    method: 'get',
		params:query
  });
}

export function getOrderVehicleCrosstown(query) {
  return fetch({
    url: '/api/order/orderVehicle/getByOrderId',
    method: 'get',
		params:query
  });
}

/**
 * 根据id获取一条违章查询记录
 * @param query
 */
export function getOneIllegalRow(id) {
  return fetch({
    url: '/api/order/orderViolation/getOne/' + id,
    method: 'get'
  });
}

/**
 * 保存违章记录
 * @param query
 * {price:图片地址(多个逗号分割)
price:退款总金额
detailId:租车订单id
}
 */
export function saveOrderViolation(params) {
  return fetch({
    url: '/api/order/orderViolation/saveOrderViolation',
    method: 'post',
    data: params
  });
}

/**
 * 获取押金退款进度
 * @param query
 */
export function getStep(orderNo) {
  return fetch({
    url: '/api/order/orderVehicle/getByOrderId?orderNo=' + orderNo,
    method: 'get'
  });
}

export function inquire(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/rent/back-stage/usable-vehicle',
    method: 'get',
    params:query
  });
}

//创建订单
export function addIndent(params) {
  return fetch({
    url: '/api/order/orderRentVehicle/back-stage/add',
    method: 'post',
    data:params
  });
}

//删除订单
export function calculate(no, params) {
  return fetch({
    url: '/api/order/baseOrder/back-stage/cancel/'+ no,
    method: 'post',
    data:params
  });
}

//创建订单
export function orderStatistics(params) {
  return fetch({
    url: 'api/order/orderStatistics/order',
    method: 'post',
    data:params
  });
}

//订单下载
export function downloadExcel(params) {
  return fetch({
    url: '/api/order/orderStatistics/excel',
    method: 'post',
    data:params,
    responseType: 'blob'
  });
}

//会员订单管理列表
export function pageList(params) {
  return fetch({
    url: '/api/order/orderMember/page',
    method: 'post',
    data: params
  });
}

//会员订单管理导出
export function orderMemberExcel(params) {
  return fetch({
    url: '/api/order/orderMember/page',
    method: 'post',
    data: params,
    responseType: 'blob'
  });
}