import fetch from 'utils/fetch';

/**
 * 分页查询
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/api/uccn/admin/friend_link/page',
    method: 'post',
    data: query
  });
}

export function findById(id) {
  return fetch({
    url: '/api/uccn/admin/friend_link/' + id,
    method: 'get'
  });
}

/**
 * 删除
 * @param query
 */
export function deleteById(id) {
  return fetch({
    url: '/api/uccn/admin/friend_link/' + id,
    method: 'delete'
  });
}

/**
 * 上下架
 * @param query
 */
export function updateOnstateById(id, onState) {
  return fetch({
    url: '/api/uccn/admin/friend_link/on_state/' + id + '/' + onState,
    method: 'put'
  });
}

/**
 * 编辑或保存
 * @param query
 */
export function save(query) {
  return fetch({
    url: '/api/uccn/admin/friend_link/save',
    method: 'post',
    data: query
  });
}


