import Vue from 'vue';
import Router from 'vue-router';

const _import = require('./_import_' + process.env.NODE_ENV);
// in development env not use Lazy Loading,because Lazy Loading large page will cause webpack hot update too slow.so only in production use Lazy Loading

Vue.use(Router);

/* layout */
import Layout from '../views/layout/Layout';

/**
 * icon : the icon show in the sidebar
 * hidden : if `hidden:true` will not show in the sidebar
 * redirect : if `redirect:noredirect` will no redirct in the levelbar
 * noDropdown : if `noDropdown:true` will has no submenu
 * meta : { role: ['admin'] }  will control the page role
 **/
export const constantRouterMap = [{
  path: '/login',
  component: _import('login/index'),
  hidden: true
},
{
  path: '/authredirect',
  component: _import('login/authredirect'),
  hidden: true
},
{
  path: '/map',
  component: _import('map'),
  name: '地图',
  hidden: true
},
{
  path: '/stockCrowd',
  component: _import('baseInfo/stockCrowd/stockCrowd'),
  name: '分公司入股',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/stockCrowdDetail',
  component: _import('baseInfo/stockCrowdDetail/index'),
  name: '入股申请',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/campsite',
  component: _import('baseInfo/campsite/campsite'),
  name: '营地',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/companyInfo',
  component: _import('baseInfo/companyInfo/index'),
  name: '公司信息',
  hidden: true
  // authority: 'companyInfo'
},
{
  path: '/provinceMap',
  component: _import('baseInfo/companyInfo/provinceMap'),
  name: '省市分布',
  hidden: true
  // authority: 'stockCrowd'
},
{
  path: '/404',
  component: _import('error/404'),
  hidden: true
},
{
  path: '/401',
  component: _import('error/401'),
  hidden: true
},
{
  path: '/',
  component: Layout,
  redirect: '/dashboard',
  name: '首页',
  hidden: true,
  children: [{
    path: 'dashboard',
    component: _import('dashboard/index')
  }]
},
{
  path: '/introduction',
  component: Layout,
  redirect: '/introduction/index',
  icon: 'form',
  noDropdown: true,
  children: [{
    path: 'index',
    component: _import('introduction/index'),
    name: '简述'
  }]
}
]

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({
    y: 0
  }),
  routes: constantRouterMap
});

export const asyncRouterMap = [{
  path: '/baseManager',
  component: Layout,
  name: '基础配置管理',
  icon: 'setting',
  authority: 'baseManager',
  children: [{
    path: 'userManager',
    icon: 'fa-user',
    component: _import('admin/user/index'),
    name: '用户管理',
    authority: 'userManager'
  }, {
    path: 'menuManager',
    icon: 'category',
    component: _import('admin/menu/index'),
    name: '菜单管理',
    authority: 'menuManager'
  }, {
    path: 'groupManager',
    icon: 'group_fill',
    component: _import('admin/group/index'),
    name: '角色权限管理',
    authority: 'groupManager'
  }, {
    path: 'groupTypeManager',
    icon: 'fa-users',
    component: _import('admin/groupType/index'),
    name: '角色类型管理',
    authority: 'groupTypeManager'
  }, {
    path: 'gateLogManager',
    icon: 'viewlist',
    component: _import('admin/gateLog/index'),
    name: '操作日志管理',
    authority: 'gateLogManager'
  }]
},
{
  path: '/authManager',
  component: Layout,
  name: '基础配置管理',
  icon: 'setting',
  authority: 'authManager',
  children: [{
    path: 'serviceManager',
    component: _import('auth/service/index'),
    name: '用户管理',
    authority: 'serviceManager'
  }]
},
{
  path: '/memberManager',
  component: Layout,
  name: '会员管理',
  icon: 'fn-user',
  authority: 'memberManager',
  children: [{
    path: 'memberInfo',
    component: _import('member/info/index'),
    authority: 'memberInfo'
  }]
},
{
  path: '/monitorManager',
  component: Layout,
  name: '监控模块管理',
  icon: 'setting',
  authority: 'monitorManager',
  children: [{
    path: 'serviceEurekaManager',
    component: _import('monitor/eureka/index'),
    name: 'Eureka注册中心',
    authority: 'serviceEurekaManager'
  }, {
    path: 'serviceMonitorManager',
    component: _import('monitor/service/index'),
    name: '服务状态监控',
    authority: 'serviceMonitorManager'
  }, {
    path: 'serviceZipkinManager',
    component: _import('monitor/zipkin/index'),
    name: '服务状态监控',
    authority: 'serviceZipkinManager'
  }]
}, {
  path: '/baseInfo',
  component: Layout,
  name: '基础信息',
  icon: 'fa-user',
  authority: 'baseInfo',
  children: [{
    path: 'branchCompany',
    component: _import('baseInfo/branchCompany/index'),
    name: '分公司管理',
    authority: 'branchCompany'
  },
  {
    path: 'campsite',
    component: _import('baseInfo/campsite/index'),
    name: '营地管理',
    authority: 'campsite'
  },
  {
    path: '/baseInfo/accompanyingItem',
    component: _import('vehicle/accompanyingItem/index'),
    name: '随行物品管理',
    authority: 'accompanyingItem'
  },
  {
    path: 'branchCompany/stock',
    component: _import('branchCompany/stock/index'),
    name: '分公司股权信息管理',
    authority: 'branchCompany/stock'
  },
  {
    path: 'branchCompany/stockApply',
    component: _import('branchCompany/stockApply/index'),
    name: '分公司股权信息管理',
    authority: 'branchCompany/stockApply'
  },
  {
    path: 'vehicleUpkeepItem',
    component: _import('vehicle/vehicleUpkeepItem/index'),
    name: '车辆保养项目管理',
    authority: 'vehicleUpkeepItem'
  }
  ]
}, {
  path: '/vehicle',
  component: Layout,
  name: '车辆管理',
  icon: 'setting',
  authority: 'vehicle',
  children: [
    {
      path: 'vehicleInfo',
      component: _import('vehicle/vehicleInfo/index'),
      name: '车辆信息管理',
      authority: 'vehicleInfo'
    },
    {
      path: 'bookRecord',
      component: _import('vehicle/bookRecord/index'),
      name: '车辆申请管理',
      authority: 'bookRecord'
    },
    {
      path: 'vehicleWarningMsg',
      component: _import('vehicle/vehicleWarningMsg/index'),
      name: '车辆预警消息',
      authority: 'vehicleWarningMsg'
    },
    {
      path: 'vehicleDepartureLog',
      component: _import('vehicle/vehicleDepartureLog/index'),
      name: '车辆出车记录',
      authority: 'vehicleDepartureLog'
    },
    {
      path: 'vehicleUpkeepLog',
      component: _import('vehicle/vehicleUpkeepLog/index'),
      name: '车辆保养记录',
      authority: 'vehicleUpkeepLog'
    }
  ]
}
];
