import fetch from 'utils/fetch';


export function page(query) {
  return fetch({
    url: '/vehicle/accompanyingItem/page',
    method: 'get',
    params: {
      queryAccompanyItemVoJson: JSON.stringify(query)
    }
  });
}

export function getAllAccItem() {
  return fetch({
    url: '/vehicle/accompanyingItem/all',
    method: 'get'
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/accompanyingItem/' + id,
    method: 'get'
  });
}

export function addObj(obj) {
  return fetch({
    url: '/vehicle/accompanyingItem',
    method: 'post',
    data: obj
  });
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/accompanyingItem',
    method: 'put',
    data: obj
  })
}

export function delObj(id) {
  return fetch({
    url: '/vehicle/accompanyingItem/' + id,
    method: 'delete'
  })
}
