import fetch from 'utils/fetch';

export function getObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/' + id,
    method: 'get'
  });
}

export function page(param) {
  return fetch({
    url: '/vehicle/branchCompany/stock/page',
    method: 'get',
    params: param
  });
}

export function search(param) {
  return fetch({
    url: '/vehicle/branchCompany/stock/search',
    method: 'get',
    params: param
  });
}

export function addObj(param) {
  return fetch({
    url: '/vehicle/branchCompany/stock',
    method: 'put',
    data: param
  });
}

export function updateObj(param) {
  return fetch({
    url: '/vehicle/branchCompany/stock',
    method: 'post',
    data: param
  });
}

export function delObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/' + id,
    method: 'delete'
  });
}
