import store from "../../../store";
import XEUtils from 'xe-utils';//加入常用工具类
import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/vehicle/campsite/page',
    method: 'get',
    params: query
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/campsite/' + id,
    method: 'get'
  });
}


export function addObj(obj) {
  console.log(obj);
  return fetch({
    url: '/vehicle/campsite/',
    method: 'post',
    data: obj
  });
}
// 股权价格
export function getAllStockPrice() {
  return fetch({
    url: '/vehicle/campsite/stock/allPrice',
    method: 'get'
  });
}

// 我要参与-众筹
export function stockApply(obj) {
  return fetch({
    url: 'vehicle/campsite/stock/apply',
    method: 'post',
    data: obj
  });
}
// 股权列表
export function stockSearchPage(query) {
  return fetch({
    url: '/vehicle/campsite/stock/search',
    method: 'get',
    params: query
  });
}


export function delObj(id) {
  return fetch({
    url: '/vehicle/campsite/' + id,
    method: 'delete'
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/campsite',
    method: 'put',
    data: obj
  })
}

export function getAll() {
  return fetch({
    url: '/vehicle/campsite',
    method: 'get'
  })
}

/**
 * 获取所有公司信息
 * @returns {null|*}
 */
export function getAllCampsite(resolve) {
    getAll().then(response => {
      let campsiteList = response.data;
      if (!campsiteList || campsiteList.length === 0) {
        return null;
      }
      let codeAndCampsite = {};
      for (let index in campsiteList) {
        codeAndCampsite[campsiteList[index].id] = campsiteList[index];
      }
      resolve(codeAndCampsite);
    });
}
