import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/admin/app/user/page',
    method: 'get',
    params: query
  });
}

export function addObj(obj) {
  console.log(obj);
  return fetch({
    url: '/api/admin/app/user',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/app/user/' + id,
    method: 'get'
  })
}

export function delObj(id) {
  return fetch({
    url: '/api/admin/app/user/' + id,
    method: 'delete'
  })
}

export function putObj(id, obj) {
  return fetch({
    url: '/api/admin/app/user/' + id,
    method: 'put',
    data: obj
  })
}

export function insertGroups(obj) {
  console.log(obj);
  return fetch({
    url: '/api/admin/app/user/groups',
    method: 'post',
    data: obj
  });
}
