import Vue from "vue";
import Router from "vue-router";

const _import = require("./_import_" + process.env.NODE_ENV);
// in development env not use Lazy Loading,because Lazy Loading large page will cause webpack hot update too slow.so only in production use Lazy Loading

Vue.use(Router);

/* layout */
import Layout from "../views/layout/Layout";

/**
 * icon : the icon show in the sidebar
 * hidden : if `hidden:true` will not show in the sidebar
 * redirect : if `redirect:noredirect` will no redirct in the levelbar
 * noDropdown : if `noDropdown:true` will has no submenu
 * meta : { role: ['admin'] }  will control the page role
 **/
export const constantRouterMap = [
  {
    path: "/login",
    component: _import("login/index"),
    hidden: true,
  },
  {
    path: "/authredirect",
    component: _import("login/authredirect"),
    hidden: true,
  },
  {
    path: "/map",
    component: _import("map"),
    name: "地图",
    hidden: true,
  },
  {
    path: "/stockCrowd",
    component: _import("baseInfo/stockCrowd/stockCrowd"),
    name: "分公司入股",
    hidden: true,
    // authority: 'stockCrowd'
  },
  {
    path: "/stockCrowdDetail",
    component: _import("baseInfo/stockCrowdDetail/index"),
    name: "入股申请",
    hidden: true,
    // authority: 'stockCrowd'
  },
  {
    path: "/campsite",
    component: _import("baseInfo/campsite/campsite"),
    name: "营地",
    hidden: true,
    // authority: 'stockCrowd'
  },
  {
    path: "/companyInfo",
    component: _import("baseInfo/companyInfo/index"),
    name: "公司信息",
    hidden: true,
    // authority: 'companyInfo'
  },
  {
    path: "/companyDetail",
    component: _import("baseInfo/companyInfo/companyDetail"),
    name: "公司详情",
    hidden: true,
    // authority: 'companyInfo'
  },
  {
    path: "/provinceMap",
    component: _import("baseInfo/companyInfo/provinceMap"),
    name: "省市分布",
    hidden: true,
    // authority: 'stockCrowd'
  },
  {
    path: "/404",
    component: _import("error/404"),
    hidden: true,
  },
  {
    path: "/401",
    component: _import("error/401"),
    hidden: true,
  },
  // {
  //   path: '/',
  //   component: Layout,
  //   redirect: '/dashboard',
  //   name: '首页',
  //   hidden: true,
  //   children: [{
  //     path: 'dashboard',
  //     component: _import('dashboard/index')
  //   }]
  // },

  {
    path: "/",
    component: Layout,
    redirect: "/index",
    name: "首页",
    hidden: true,
    children: [
      {
        path: "index",
        component: _import("index/index"),
      },
    ],
  },
  {
    path: "/introduction",
    component: Layout,
    redirect: "/introduction/index",
    icon: "form",
    noDropdown: true,
    children: [
      {
        path: "index",
        component: _import("introduction/index"),
        name: "简述",
      },
    ],
  },
];

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({
    y: 0,
  }),
  routes: constantRouterMap,
});

export const asyncRouterMap = [
  {
    path: "/baseManager",
    component: Layout,
    name: "基础配置管理",
    icon: "setting",
    authority: "baseManager",
    children: [
      {
        path: "userManager",
        icon: "fa-user",
        component: _import("admin/user/index"),
        name: "后台用户管理",
        authority: "userManager",
      },
      {
        path: "appUserManager",
        icon: "fa-user",
        component: _import("admin/appUser/index"),
        name: "App用户管理",
        authority: "appUserManager",
      },
      {
        path: "menuManager",
        icon: "category",
        component: _import("admin/menu/index"),
        name: "菜单管理",
        authority: "menuManager",
      },
      {
        path: "groupManager",
        icon: "group_fill",
        component: _import("admin/group/index"),
        name: "角色权限管理",
        authority: "groupManager",
      },
      {
        path: "groupTypeManager",
        icon: "fa-users",
        component: _import("admin/groupType/index"),
        name: "角色类型管理",
        authority: "groupTypeManager",
      },
      {
        path: "gateLogManager",
        icon: "viewlist",
        component: _import("admin/gateLog/index"),
        name: "操作日志管理",
        authority: "gateLogManager",
      },
    ],
  },
  {
    path: "/authManager",
    component: Layout,
    name: "基础配置管理",
    icon: "setting",
    authority: "authManager",
    children: [
      {
        path: "serviceManager",
        component: _import("auth/service/index"),
        name: "用户管理",
        authority: "serviceManager",
      },
    ],
  },
  {
    path: "/memberManager",
    component: Layout,
    name: "会员管理",
    icon: "fn-user",
    authority: "memberManager",
    children: [
      {
        path: "memberInfo",
        component: _import("member/info/index"),
        authority: "memberInfo",
      },
    ],
  },
  {
    path: "/monitorManager",
    component: Layout,
    name: "监控模块管理",
    icon: "setting",
    authority: "monitorManager",
    children: [
      {
        path: "serviceEurekaManager",
        component: _import("monitor/eureka/index"),
        name: "Eureka注册中心",
        authority: "serviceEurekaManager",
      },
      {
        path: "serviceMonitorManager",
        component: _import("monitor/service/index"),
        name: "服务状态监控",
        authority: "serviceMonitorManager",
      },
      {
        path: "serviceZipkinManager",
        component: _import("monitor/zipkin/index"),
        name: "服务状态监控",
        authority: "serviceZipkinManager",
      },
    ],
  },
  {
    path: "/baseInfo",
    component: Layout,
    name: "基础信息",
    icon: "fa-user",
    authority: "baseInfo",
    children: [
      {
        path: "branchCompany",
        component: _import("baseInfo/branchCompany/index"),
        name: "分公司管理",
        authority: "branchCompany",
      },
      {
        path: "campsite",
        component: _import("baseInfo/campsite/index"),
        name: "营地管理",
        authority: "campsite",
      },
      {
        path: "/baseInfo/accompanyingItem",
        component: _import("vehicle/accompanyingItem/index"),
        name: "随行物品管理",
        authority: "accompanyingItem",
      },
      {
        path: "branchCompany/stock",
        component: _import("branchCompany/stock/index"),
        name: "分公司股权信息管理",
        authority: "branchCompany/stock",
      },
      {
        path: "branchCompany/stockApply",
        component: _import("branchCompany/stockApply/index"),
        name: "分公司股权信息管理",
        authority: "branchCompany/stockApply",
      },
      {
        path: "vehicleUpkeepItem",
        component: _import("vehicle/vehicleUpkeepItem/index"),
        name: "车辆保养项目管理",
        authority: "vehicleUpkeepItem",
      },
      {
        path: "generalSetting",
        component: _import("baseInfo/generalSetting"),
        name: "通用设置",
        authority: "generalSetting",
      },
    ],
  },
  {
    path: "/vehicleType",
    component: Layout,
    name: "车型管理",
    icon: "setting",
    authority: "vehicleType",
    children: [
      {
        path: "vehicleTypeList",
        component: _import("vehicleType/index"),
        name: "车型列表",
        authority: "vehicleTypeList",
      },
      {
        path: "vehicleTypeLabel",
        component: _import("vehicleType/vehicleTypeLabel"),
        name: "车型标签设置",
        authority: "vehicleTypeLabel",
      },
      {
        path: "priceList",
        component: _import("vehicleType/priceList"),
        name: "租车价格表",
        authority: "priceList",
      },
      {
        path: "mockSun",
        component: _import("vehicleType/mockSun"),
        name: "节日价格",
        authority: "mockSun",
      },
    ],
  },
  {
    path: "/discoveryModule",
    component: Layout,
    name: "发现模块",
    icon: "setting",
    authority: "discoveryModule",
    children: [
      {
        path: "clapIndex",
        component: _import("discoveryModule/clapIndex"),
        name: "拍拍",
        authority: "clapIndex",
      },
      {
        path: "shortVideo",
        component: _import("discoveryModule/shortVideo"),
        name: "短视频",
        authority: "shortVideo",
      },
      {
        path: "questionsAndAnswers",
        component: _import("discoveryModule/questionsAndAnswers"),
        name: "问答",
        authority: "questionsAndAnswers",
      },
    ],
  },
  {
    path: "/campsiteManage",
    component: Layout,
    name: "营地管理",
    icon: "setting",
    authority: "campsiteManage",
    children: [
      {
        path: "campsiteList",
        component: _import("campsiteManage/index"),
        name: "营地列表",
        authority: "campsiteList",
      },
      {
        path: "campsiteLabel",
        component: _import("campsiteManage/campsiteLabel"),
        name: "营地标签设置",
        authority: "campsiteLabel",
      },
    ],
  },
  {
    path: "/revenue",
    component: Layout,
    name: "营地管理",
    icon: "setting",
    authority: "revenue",
    children: [
      {
        path: "revenue_sum",
        component: _import("revenue/revenue_sum"),
        name: "营收概况",
        authority: "revenue_sum",
      },
      {
        path: "revenue_withdraw",
        component: _import("revenue/revenue_withdraw"),
        name: "提现列表",
        authority: "revenue_withdraw",
      },
    ],
  },
  {
    path: "/vehicle",
    component: Layout,
    name: "车辆管理",
    icon: "setting",
    authority: "vehicle",
    children: [
      {
        path: "vehicleInfo",
        component: _import("vehicle/vehicleInfo/index"),
        name: "车辆信息管理",
        authority: "vehicleInfo",
      },
      {
        path: "vehiclePrice",
        component: _import("vehicle/vehiclePrice"),
        name: "车辆价格管理",
        authority: "vehiclePrice",
      },
      {
        path: "bookRecord",
        component: _import("vehicle/bookRecord/index"),
        name: "车辆排班管理",
        authority: "bookRecord",
      },
      {
        path: "bookingManagement",
        component: _import("vehicle/smallProgram/bookingManagement"),
        name: "小程序车辆申请管理",
        authority: "bookingManagement",
      },
      {
        path: "vehicleWarningMsg",
        component: _import("vehicle/vehicleWarningMsg/index"),
        name: "车辆预警消息",
        authority: "vehicleWarningMsg",
      },
      {
        path: "vehicleDepartureLog",
        component: _import("vehicle/vehicleDepartureLog/index"),
        name: "车辆出车记录",
        authority: "vehicleDepartureLog",
      },
      {
        path: "vehicleUpkeepLog",
        component: _import("vehicle/vehicleUpkeepLog/index"),
        name: "车辆保养记录",
        authority: "vehicleUpkeepLog",
      },
      {
        path: "vehicleSchedulManage",
        component: _import("vehicle/vehicleSchedulManage/index"),
        name: "车辆排班表",
        authority: "vehicleSchedulManage",
      },
      {
        path: "vehicleRecords",
        component: _import("vehicle/vehicleSchedulManage/vehicleRecords"),
        name: "车辆排班记录",
        authority: "vehicleRecords",
      },
      {
        path: "vehicleCount",
        component: _import("vehicle/vehicleCount/index"),
        name: "车辆出行统计",
        authority: "vehicleCount",
      },
      {
        path: "vehicleTypeList",
        component: _import("vehicleType/index"),
        name: "车型列表",
        authority: "vehicleTypeList",
      },
      {
        path: "vehicleTypeLabel",
        component: _import("vehicleType/vehicleTypeLabel"),
        name: "车型标签设置",
        authority: "vehicleTypeLabel",
      },
      {
        path: "accompanyingItem",
        component: _import("vehicle/accompanyingItem/index"),
        name: "随行物品管理",
        authority: "accompanyingItem",
      },
      // {
      //   path: 'dispatchApply',
      //   component: _import('vehicle/dispatchApply/index'),
      //   name: '调度申请管理',
      //   authority: 'dispatchApply'
      // }
    ],
  },
  {
    path: "/tourManage",
    component: Layout,
    name: "旅行管理",
    icon: "setting",
    authority: "tourManage",
    children: [
      {
        path: "tourList",
        component: _import("tourManage/index"),
        name: "旅行列表",
        authority: "tourList",
      },
      {
        path: "tourLabel",
        component: _import("tourManage/tourLabel"),
        name: "旅行标签设置",
        authority: "tourLabel",
      },
    ],
  },
  {
    path: "/order",
    component: Layout,
    name: "订单管理",
    icon: "setting",
    authority: "order",
    children: [
      {
        path: "rentVehicleInfo",
        component: _import("order/rentVehicleInfo/index"),
        name: "租车订单管理",
        authority: "rentVehicleInfo",
      },
      {
        path: "tourOrderInfo",
        component: _import("order/tourOrderInfo/index"),
        name: "旅游订单管理",
        authority: "tourOrderInfo",
      },
      {
        path: "memberOrderInfo",
        component: _import("order/memberOrderInfo/index"),
        name: "会员订单管理",
        authority: "memberOrderInfo",
      },
      {
        path: "orderStatistics",
        component: _import("order/orderStatistics/index"),
        name: "会员订单统计",
        authority: "orderStatistics",
      },
      {
        path: "createOrder",
        component: _import("order/createOrder/index"),
        name: "创建租车订单",
        authority: "createOrder",
      },
      {
        path: "orderActiveInfo",
        component: _import("order/orderActiveInfo/index"),
        name: "活动订单管理",
        authority: "orderActiveInfo",
      },
    ],
  },
  {
    path: "/purseManage",
    component: Layout,
    name: "钱包管理",
    icon: "setting",
    authority: "purseManage",
    children: [
      {
        path: "incomeOverview",
        component: _import("purseManage/incomeOverview"),
        name: "收益总览",
        authority: "incomeOverview",
      },
      {
        path: "gainRecord",
        component: _import("purseManage/gainRecord"),
        name: "收益记录",
        authority: "gainRecord",
      },
      {
        path: "commissionSettings",
        component: _import("purseManage/commissionSettings"),
        name: "佣金设置比例",
        authority: "commissionSettings",
      },
      {
        path: "discountRecord",
        component: _import("purseManage/discountRecord"),
        name: "提现记录",
        authority: "discountRecord",
      },
      {
        path: "commissionRecord",
        component: _import("purseManage/commissionRecord"),
        name: "佣金记录",
        authority: "commissionRecord",
      },
    ],
  },
  {
    path: "/userManagement",
    component: Layout,
    name: "用户管理",
    icon: "setting",
    authority: "userManagement",
    children: [
      {
        path: "userList",
        component: _import("userManagement/userList/index"),
        name: "用户列表",
        authority: "userList",
      },
      {
        path: "memberManagement",
        component: _import("userManagement/memberManagement/index"),
        name: "会员管理1",
        authority: "memberManagement",
      },
      {
        path: "memberEnter",
        component: _import("userManagement/memberEnter"),
        name: "会员录入",
        authority: "memberEnter",
      },
      {
        path: "imCustomerServiceManger",
        component: _import(
          "userManagement/imCustomerServiceManger/cusomterServiceList"
        ),
        name: "客服列表",
        authority: "imCustomerServiceManger",
      },
    ],
  },
  {
    path: "/appManagement",
    component: Layout,
    name: "app管理",
    icon: "setting",
    authority: "appManagement",
    children: [
      {
        path: "bannerSetting",
        component: _import("baseInfo/bannerSetting"),
        name: "banner设置",
        authority: "bannerSetting",
      },
      {
        path: "appVersion",
        component: _import("appManagement/appVersion/index"),
        name: "app版本管理",
        authority: "appVersion",
      },
      {
        path: "appVersionMark",
        component: _import("appManagement/appVersionMark"),
        name: "标识管理",
        authority: "appVersionMark",
      },
      {
        path: "modalManagement",
        component: _import("appManagement/modalManagement/index"),
        name: "首页弹窗管理",
        authority: "modalManagement",
      },
      {
        path: "selectedActivities",
        component: _import("appManagement/selectedActivities/index"),
        name: "首页精选活动",
        authority: "selectedActivities",
      },
      {
        path: "pushManagement",
        component: _import("appManagement/pushManagement/index"),
        name: "消息推送",
        authority: "pushManagement",
      },
      {
        path: "generalSetting",
        component: _import("baseInfo/generalSetting"),
        name: "通用设置",
        authority: "generalSetting",
      },
    ],
  },
  {
    path: "/summit",
    component: Layout,
    name: "峰会管理",
    icon: "setting",
    authority: "summit",
    children: [
      {
        path: "index",
        component: _import("summit/index"),
        name: "峰会列表",
        authority: "index",
      },
    ],
  },
  {
    path: "/cunponManagements",
    component: Layout,
    name: "优惠券管理",
    icon: "setting",
    authority: "cunponManagements",
    children: [
      {
        path: "cunponManagement",
        component: _import("cunponManagements/cunponManagement"),
        name: "优惠券管理",
        authority: "cunponManagement",
      },
      {
        path: "conponList",
        component: _import("cunponManagements/conponList"),
        name: "优惠券列表",
        authority: "conponList",
      },
    ],
  },
  {
    path: "/activityManagement",
    component: Layout,
    name: "活动管理",
    icon: "setting",
    authority: "activityManagement",
    children: [
      {
        path: "activityList",
        component: _import("activityManagement/activityList"),
        name: "活动列表",
        authority: "activityList",
      },
    ],
  },
  {
    path: "/company",
    component: Layout,
    name: "公司/门店",
    icon: "setting",
    authority: "company",
    children: [
      {
        path: "companyManage",
        component: _import("company/companyManage"),
        name: "公司管理",
        authority: "companyManage",
      },
      {
        path: "storeManage",
        component: _import("company/storeManage"),
        name: "门店管理",
        authority: "storeManage",
      },
    ],
  },
  {
    path: "/casual",
    component: Layout,
    name: "发布会现金活动",
    icon: "setting",
    authority: "casual",
    children: [
      {
        path: "index",
        component: _import("conference/activeData/index"),
        name: "活动数据",
        authority: "index",
      },
      {
        path: "prizeLists",
        component: _import("conference/prizeList/prizeLists"),
        name: "中奖列表",
        authority: "prizeLists",
      },
      {
        path: "applyList",
        component: _import("conference/apply/applyList"),
        name: "报名列表",
        authority: "applyList",
      },
      {
        path: "awardSet",
        component: _import("conference/award/awardSet"),
        name: "奖品设置",
        authority: "awardSet",
      },
    ],
  },
  {
    path: "/applyManagements",
    component: Layout,
    name: "申请管理",
    icon: "setting",
    authority: "applyManagements",
    children: [
      {
        path: "carApplyList",
        component: _import("applyManagements/carApplyList"),
        name: "购房车申请列表",
        authority: "carApplyList",
      },
      {
        path: "Settlement",
        component: _import("applyManagements/Settlement"),
        name: "入驻申请",
        authority: "Settlement",
      },
    ],
  },
  {
    path: "/xxOfficialWebsite",
    component: Layout,
    name: "欣新房车官网管理",
    icon: "setting",
    authority: "xxOfficialWebsite",
    children: [
      {
        path: "activityList",
        component: _import("xxOfficialWebsite/activityList"),
        name: "活动管理",
        authority: "activityList",
      },
      {
        path: "newsList",
        component: _import("xxOfficialWebsite/newsList"),
        name: "新闻管理",
        authority: "newsList",
      },
      {
        path: "bannerList",
        component: _import("xxOfficialWebsite/bannerList"),
        name: "banner管理",
        authority: "bannerList",
      },
      {
        path: "seoList",
        component: _import("xxOfficialWebsite/seoList"),
        name: "SEO管理",
        authority: "seoList",
      },
      {
        path: "friendLinkList",
        component: _import("xxOfficialWebsite/friendLinkList"),
        name: "友情连接",
        authority: "friendLinkList",
      },
    ],
  },
  {
    path: "/summit",
    component: Layout,
    name: "峰会管理",
    icon: "setting",
    authority: "summit",
    children: [
      {
        path: "summitList",
        component: _import("summit/index"),
        name: "峰会列表",
        authority: "summitList",
      },
    ],
  },
  {
    path: "/statistics",
    component: Layout,
    name: "数据统计",
    icon: "setting",
    authority: "statistics",
    children: [
      {
        path: "orderStatistics",
        component: _import("statistics/orderStatistics"),
        name: "订单统计",
        authority: "orderStatistics",
      },
    ],
  },
  {
    path: "/financial",
    component: Layout,
    name: "财务报表",
    icon: "setting",
    authority: "financial",
    children: [
      {
        path: "staffPerformance",
        component: _import("financial/staffPerformance"),
        name: "员工业绩报表",
        authority: "staffPerformance",
      },
      {
        path: "memberPerformance",
        component: _import("financial/memberPerformance"),
        name: "总公司报表",
        authority: "memberPerformance",
      },
      {
        path: "branchCompany",
        component: _import("financial/branchCompany"),
        name: "总公司报表",
        authority: "branchCompany",
      },
      {
        path: "vehicleStatistics",
        component: _import("financial/vehicleStatistics"),
        name: "车辆统计",
        authority: "vehicleStatistics",
      },
    ],
  },
  {
    path: "/interior",
    component: Layout,
    name: "内部人员管理",
    icon: "setting",
    authority: "interior",
    children: [
      {
        path: "employeesInput",
        component: _import("interior/employeesInput"),
        name: "员工录入",
        authority: "employeesInput",
      },
      {
        path: "shareholder",
        component: _import("interior/shareholder"),
        name: "股东列表",
        authority: "shareholder",
      },
    ],
  },
];
