import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/page',
    method: 'get',
    params: {vehiclePageQueryVoJson: query}
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/' + id,
    method: 'get'
  });
}

/**
 * 添加车辆
 */
export function addObj(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo',
    method: 'post',
    data: [obj]
  });
}

/*
* 删除一条车辆数据
* */
export function delObj(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/del/' + id,
    method: 'delete'
  });
}

export function book(param) {
  return fetch({
    url: '/vehicle/vehicleInfo/apply/book/vehicle',
    method: 'post',
    data: param
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo',
    method: 'put',
    data: [obj]
  })
}

export function getBookedInfoIn2Month(vehicleId) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedInfo/' + vehicleId,
    method: 'get'
  });
}

export function getBookedInfo(vehicleId, yearMonth) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedInfo/' + vehicleId + '/' + yearMonth,
    method: 'get'
  });
}

/*
* 根据id获取片区下省份
* */
export function getSysRegionByIds(ids) {
  return fetch({
    url: '/vehicle/sysRegion/getSysRegionByIds/' + ids,
    method: 'get'
  });

}

export function getSysRegionById(id) {
  return fetch({
    url: '/vehicle/sysRegion/getSysRegionById/' + id,
    method: 'get'
  });
}

//重新配车
export function editObj(param) {
  return fetch({
    url: '/api/order/baseOrder/bg/change-vehicle',
    method: 'post',
    data: param
  });
}

//检查车辆编码是否存在
export function checkCode(code, id) {
  return fetch({
    url: '/vehicle/vehicleInfo/exist_code/' + code + '?id=' + id,
    method: 'get'
  });
}

//检查车架号是否存在
export function checkVin(vin, id) {
  return fetch({
    url: '/vehicle/vehicleInfo/exist_vin/' + vin + '?id=' + id,
    method: 'get'
  });
}

//检查车辆发动机号是否存在
export function checkEngineNum(engineNum, id) {
  return fetch({
    url: '/vehicle/vehicleInfo/exist_engineNum/' + engineNum + '?id=' + id,
    method: 'get'
  });
}

export function downloadExcel(query) {
  return fetch({
    url: '/vehicle/VehicleInformationDownload/excel',
    method: 'get',
    params: {vehiclePageQueryVoJson: query},
    responseType: 'blob'
  });
}

export function exportExcel(query) {
  return fetch({
    url: '/vehicle/VehicleInformationDownload/app/unauth/export',
    method: 'get',
    responseType: 'blob'
  });
}

export function postponeApi(param) {
  return fetch({
    url: 'api/order/baseOrder/bg/delay-rent-order',
    method: 'post',
    data: param
  });
}

// 2020-08-26  lixy
/**
 * 所属门店-条件筛选
 */
export function vehicleBranchCompanyAll(query) {
  return fetch({
    url: 'vehicle/branchCompany/alls',
    method: 'get',
    params: query
  });
}

/**
 * 所属公司--条件查询
 */
export function vehicleCompanyAll(query) {
  return fetch({
    url: 'vehicle/company/info/alls',
    method: 'get',
    params: query
  });
}

/**
 * 获取车辆价格列表--分页
 */
export function vehicleCommonPriceInfo(query) {
  return fetch({
    url: 'vehicle/vehicleCommonPriceInfo/getAll',
    method: 'get',
    params: query
  });
}

/**
 * 获取车辆价格详情
 */
export function vehicleCommonPriceOne(query) {
  return fetch({
    url: 'vehicle/vehicleCommonPriceInfo/getOne',
    method: 'get',
    params: query
  });
}

/**
 * 保存--通用价格
 */
export function vehicleCommonPriceUpdate(query) {
  return fetch({
    url: 'vehicle/vehicleCommonPriceInfo/admin/addOrUpdate',
    method: 'post',
    data: query
  });
}

/**
 * 获取节假日列表、节假日编辑
 */
export function getAllFestivalPrice(query) {
  return fetch({
    url: 'vehicle/vehicleHolidayPriceInfo/getAll',
    method: 'get',
    params: query
  });
}

/**
 * 获取节假日详情
 */
export function getOneFestivalPrice(query) {
  return fetch({
    url: 'vehicle/vehicleHolidayPriceInfo/getOne',
    method: 'get',
    params: query
  });
}

/**
 * 添加、编辑节假日
 */
export function saveOrUpdateFestivalPrice(query) {
  return fetch({
    url: 'vehicle/vehicleHolidayPriceInfo/saveOrUpdate',
    method: 'post',
    data: query
  });
}

/**
 * 生产商
 */
export function allManufacturer(query) {
  return fetch({
    url: 'vehicle/vehicleInfo/getAllManufacturer',
    method: 'get',
    params: query
  });
}

/**
 * 删除节假日
 */
export function deleteFestival(query) {
  return fetch({
    url: 'vehicle/vehicleHolidayPriceInfo/deleteByVehicleId',
    method: 'delete',
    params: query
  });
}

