// eslint-disable-next-line linebreak-style
import fetch from 'utils/fetch'
import store from '../store';
import rsCode from '../utils/rsCode';
//旅游标签
export function getAllTourTag(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/tags',
    method: 'get',
    params: query
  });
}
//列表
export function travelPage(query) {
  return fetch({
    url: '/api/tour/good/admin/goodList',
    method: 'post',
    data: query
  });
}

export function goodsEdit(query) {
  return fetch({
    url: '/api/tour/good/admin/goodEdit',
    method: 'post',
    data: query
  });
}

export function getOneGoodsById(query) {
  return fetch({
    url: '/api/tour/good/admin/goodOne',
    method: 'get',
    params: query
  });
}

export function getTourTagList(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/pages',
    method: 'get',
    params: query
  });
}


export function getAll() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  })
}



export function goodDel(id) {
  return fetch({
    url: '/api/tour/good/admin/goodDel/' + id,
    method: 'get'
  });
}



/**
 * 上架、下架
 * */
export function upStatusChange(query) {
  return fetch({
    url: '/api/tour/good/admin/upStatus',
    method: 'get',
    params: query
  });
}

/**
 * 获取省份列表
 */
export function getSonRegionByType(query) {
  return fetch({
    url: '/api/universal/sysRegion/getSonRegionByType/1',
    method: 'get',
    params: query
  });
}

/**
 * 获取市区份列表
 */
export function getSons(query) {
  return fetch({
    url: '/api/universal/sysRegion/sons/' + query,
    method: 'get',
    //   params: query
  });
}
/**
 * 获取所有公司信息
 * @returns {null|*}
 */
export function getAllCompany(resolve) {
  getAll().then(response => {
    let companyList = response.data;
    if (!companyList || companyList.length === 0) {
      return null;
    }
    let codeAndBranchCompany = {};
    for (let index in companyList) {
      codeAndBranchCompany[companyList[index].id] = companyList[index];
    }
    resolve(codeAndBranchCompany);
  });
}


export function getSonRegionByCodes(code) {
  let actualCode = code;
  if (!actualCode) {
    actualCode = rsCode.REGION_CODE_CHAINA;
  }
  let sonRegions = store.getters.sonRegions(actualCode);
  if (!sonRegions) {
    let datas = loadSonsFromServer(actualCode);
    store.dispatch("cacheSonRegions", {
      code: actualCode,
      sons: datas
    });
    sonRegions = datas;
  }

  // 创建axios实例
  return sonRegions;
}

export function getRegionByCodes(codes) {
  if (!codes) {
    console.error('empty region codes');
    return null;
  }
  let regions = [];
  let hasLoaded = true;
  for (let index in codes) {
    let region = store.getters.region(codes[index]);
    if (!region) {
      hasLoaded = false;
      break;
    }
    regions = [...regions, region];
  }

  if (!hasLoaded) {
    let datas = loadFromServer(codes);
    for (let index = datas.length - 1; index >= 0; index--) {
      regions = [datas[index], ...regions];
    }
    store.dispatch("cacheRegion", regions);
  }
  return regions;
}

export function tourTagUpdate(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/update',
    method: 'put',
    data: query
  });
}

export function tourTagAdd(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/save',
    method: 'post',
    data: query
  });
}


export function tourTagHot(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/update/hot',
    method: 'put',
    params: query
  });
}

/**
 *删除旅游标签
 */
export function deleteTourTag(id) {
  return fetch({
    url: '/api/tour/admin/tourTag/' + id,
    method: 'delete'
  });
}

/**
 * 判断标签是否已存在
 * @param id
 */
export function existTourTag(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/exist',
    method: 'get',
    params: query
  });
}

//规格
export function specification(tourId) {
  return fetch({
    url: '/api/tour/good/spe/' + tourId,
    method: 'get'
  });
}
