import fetch from 'utils/fetch';

export function appPage(obj) {
  return fetch({
    url: '/api/admin/appUsersManage/findAll',
    method: 'post',
    timeout: '30000',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/appUsersManage/findOneById/'+id,
    method: 'get',
  });
}


export function setAvailable(id) {
  return fetch({
    url: '/api/admin/appUsersManage/available/'+id,
    method: 'put',
  });
}

export function setDisable(id) {
  return fetch({
    url: '/api/admin/appUsersManage/disable/'+id,
    method: 'put',
  });
}

export function seveObj(obj) {
  return fetch({
    url: '/api/admin/baseUserMember/setUserMember',
    method: 'put',
    data:obj
  });
}
/**
 * 会员录入-列表
 * */
export function getMemberEntryList(query) {
  return fetch({
    url: '/api/admin/admin/member/page',
    method: 'get',
    params: query
  });
}

/**
 * 会员录入-删除
 */
export function delMemberObj(id) {
  return fetch({
    url: '/api/admin/admin/member/' + id,
    method: 'delete'
  });
}


/**
 * 用户列表-删除
 * @param id
 */
export function deleteUser(id) {
  return fetch({
    url: '/api/admin/appUsersManage/deleteById/' + id,
    method: 'delete'
  });
}

/**
 * 身份设置
 * @param obj
 */
export function userPosition(obj) {
  return fetch({
    url: '/api/admin/appUsersManage/user_position?id='+obj.id+'&positionId='+obj.positionId,
    method: 'put',
  });
}

// 用户身份录入列表
export function staffList(obj) {
  return fetch({
    url: '/api/admin/postion/admin/page',
    method: 'post',
    data: obj
  });
}

// 身份列表
export function postions(obj) {
  return fetch({
    url: '/api/admin/postion/admin/postions',
    method: 'get',
    data: obj
  });
}

// 身份列表
export function jobs(obj) {
  return fetch({
    url: '/api/admin/postion/admin/jobs',
    method: 'get',
    data: obj
  });
}

// 添加员工
export function addEditor(obj) {
  return fetch({
    url: '/api/admin/postion/admin/updUserPostion',
    method: 'post',
    data: obj
  });
}

// 编辑员工
export function editorUpd(obj) {
  return fetch({
    url: '/api/admin/postion/admin/updUserPostion',
    method: 'post',
    data: obj
  });
}
//删除员工
export function deleteStaffs(id) {
  return fetch({
    url: '/api/admin/postion/admin/' + id,
    method: 'delete'
  });
}

//检测员工
export function checkStaffs(id) {
  return fetch({
    url: '/api/admin/api/app/unauth/check?phone='+id,
    method: 'get'
  });
}


export function username(id) {
  return fetch({
    url: 'api/admin/public/app/userinfo-by-username?name='+id,
    method: 'get'
  });
}

/**
 *  用户详情
 * @param obj
 */
export function getOne(id) {
  return fetch({
    url: '/api/admin/appUsersManage/user_info/'+id,
    method: 'get',
  });
}

// 员工变更记录
export function findPositionChangeRecord(params) {
  return fetch({
    url: 'api/admin/postion/admin/findPositionChangeRecord',
    method: 'get',
    params: params
  });
}

// 员工修改
export function updUserChange(params) {
  return fetch({
    url: 'api/admin/postion/admin/updUserChange',
    method: 'post',
    data: params
  });
}

// 离职后在职
export function updAddPositionChangeRecord(params) {
  return fetch({
    url: 'api/admin/postion/admin/updAddPositionChangeRecord',
    method: 'post',
    data: params
  });
}

// 信息修改
// export function updUserPostion(params) {
//   return fetch({
//     url: 'api/admin/postion/admin/updUserPostion',
//     method: 'post',
//     data: params
//   });
// }

// 股东列表
export function stockholderList(query) {
  return fetch({
    url: 'api/admin/appShareholder/page',
    method: 'post',
    data: query
  });
}

// 新增股东
export function addUserPostion(query) {
  return fetch({
    url: 'api/admin/appShareholder/addUserPostion',
    method: 'post',
    data: query
  });
}

// 批量导入股东
export function exports(query) {
  return fetch({
    url: 'api/admin/appShareholder/export',
    method: 'post',
    data: query
  });
}

// 编辑股东信息
export function updUserPostionEditor(query) {
  return fetch({
    url: 'api/admin/appShareholder/updUserPostion',
    method: 'post',
    data: query
  });
}

// 股东信息变更记录
export function findShareholderChangeRecord(query) {
  return fetch({
    url: 'api/admin/appShareholder/findShareholderChangeRecord',
    method: 'get',
    params: query
  });
}