import fetch from 'utils/fetch';

/**
 * 获取优惠券管理列表
 * @param query
 */
export function cunponManagementList(query) {
    return fetch({
      url: '/api/activity/admin/coupon/page',
      method: 'Get',
      params: query
    });
}

/**
 * 优惠券管理列表删除
 * @param query
 */
export function delObj(id) {
  return fetch({
    url: '/api/activity/admin/coupon/' + id,
    method: 'delete'
  })
}

/**
 * 获取优惠券管理列表某一条数据
 * @param query
 */
export function getObj(id) {
  return fetch({
    url: '/api/activity/admin/coupon/' + id,
    method: 'Get'
  })
}

/**
 * 获取优惠券管理列表--添加编辑
 * @param query
 */
export function addObj(obj) {
  return fetch({
    url: '/api/activity/admin/coupon',
    method: 'post',
    data: obj
  });
}

/**
 * 获取优惠券列表--优惠券标题列表
 * @param query
 */
export function getTitle() {
  return fetch({
    url: '/api/activity/admin/coupon/titles',
    method: 'Get',
  });
}

/**
 * 获取优惠券列表--优惠券列表
 * @param query
 */
export function getCouponList(query) {
  return fetch({
    url: '/api/activity/admin/user_coupon/page',
    method: 'Get',
    params: query
  });
}

/**
 * 获取优惠券列表--发券
 * @param query
 */
export function giveObj(obj) {
  return fetch({
    url: '/api/activity/admin/user_coupon/sendcoupon',
    method: 'POST',
    data: obj
  });
}

/**
 * 优惠券列表删除
 * @param query
 */
export function delObjOne(id) {
  return fetch({
    url: '/api/activity/admin/user_coupon/' + id,
    method: 'delete'
  })
}