import fetch from 'utils/fetch';

/**
 * 获取列表
 * @param query
 */
export function getActivityList(query) {
  return fetch({
    url: '/api/activity/homeActivities/manage/activity/findAll',
    method: 'POST',
    data:query
  });
}

/**
 * 获取弹窗管理列表某一条数据
 * @param query
 */
export function getObj(id) {
  return fetch({
    url: '/api/activity/homeActivities/manage/activity/getOne/'+id,
    method: 'Get'
  })
}

/**
 * 弹窗管理--添加
 * @param query
 */
export function addObj(obj) {
    return fetch({
      url: '/api/activity/homeActivities',
      method: 'post',
      data: obj
    });
  }

/**
 * 编辑某一条数据,上下架
 * @param query
 */
export function editObj(data) {
  return fetch({
    url: '/api/activity/homeActivities/'+data.id,
    method: 'put',
    data: data
  })
}

/**
 * 删除数据
 * @param query
 */
export function delObj(id) {
  return fetch({
    url: '/api/activity/homeActivities/manage/activity/deleteOne/' + id,
    method: 'delete',
  })
}


