// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue';
import App from './App';
import router from './router';
import store from './store';
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-default/index.css';
import 'assets/custom-theme/index.css'; // 换肤版本element-ui css
import NProgress from 'nprogress'; // Progress 进度条
import 'nprogress/nprogress.css';// Progress 进度条 样式
import 'normalize.css/normalize.css';// normalize.css 样式格式化
import 'assets/iconfont/iconfont'; // iconfont 具体图标见https://github.com/PanJiaChen/vue-element-admin/wiki
import * as filters from './filters'; // 全局vue filter
import Multiselect from 'vue-multiselect';// 使用的一个多选框组件，element-ui的select不能满足所有需求
import 'vue-multiselect/dist/vue-multiselect.min.css';// 多选框组件css
import Sticky from 'components/Sticky'; // 粘性header组件
import IconSvg from 'components/Icon-svg';// svg 组件
import vueWaves from './directive/waves';// 水波纹指令
import errLog from 'store/errLog';// error log组件
// import './mock/index.js';  // 该项目所有请求使用mockjs模拟
import { getToken } from 'utils/auth';
import 'babel-polyfill';//支持IE执行原生script
import XEUtils from 'xe-utils';//加入常用工具类
import VXEUtils from 'vxe-utils';//加入常用工具类
import BaiduMap from 'vue-baidu-map'
import '../node_modules/echarts/map/js/china.js' // 引入中国地图数据
import '../node_modules/echarts/map/js/province/aomen.js'
import '../node_modules/echarts/map/js/province/beijing.js'
import '../node_modules/echarts/map/js/province/chongqing.js'
import '../node_modules/echarts/map/js/province/fujian.js'
import '../node_modules/echarts/map/js/province/gansu.js'
import '../node_modules/echarts/map/js/province/guangdong.js'
import '../node_modules/echarts/map/js/province/guangxi.js'
import '../node_modules/echarts/map/js/province/guizhou.js'
import '../node_modules/echarts/map/js/province/hainan.js'
import '../node_modules/echarts/map/js/province/hebei.js'
import '../node_modules/echarts/map/js/province/heilongjiang.js'
import '../node_modules/echarts/map/js/province/henan.js'
import '../node_modules/echarts/map/js/province/hubei.js'
import '../node_modules/echarts/map/js/province/hunan.js'
import '../node_modules/echarts/map/js/province/jiangsu.js'
import '../node_modules/echarts/map/js/province/jiangxi.js'
import '../node_modules/echarts/map/js/province/jilin.js'
import '../node_modules/echarts/map/js/province/liaoning.js'
import '../node_modules/echarts/map/js/province/neimenggu.js'
import '../node_modules/echarts/map/js/province/ningxia.js'
import '../node_modules/echarts/map/js/province/qinghai.js'
import '../node_modules/echarts/map/js/province/shandong.js'
import '../node_modules/echarts/map/js/province/shanghai.js'
import '../node_modules/echarts/map/js/province/shanxi.js'
import '../node_modules/echarts/map/js/province/shanxi1.js'
import '../node_modules/echarts/map/js/province/sichuan.js'
import '../node_modules/echarts/map/js/province/taiwan.js'
import '../node_modules/echarts/map/js/province/tianjin.js'
import '../node_modules/echarts/map/js/province/xianggang.js'
import '../node_modules/echarts/map/js/province/xinjiang.js'
import '../node_modules/echarts/map/js/province/xizang.js'
import '../node_modules/echarts/map/js/province/yunnan.js'
import '../node_modules/echarts/map/js/province/zhejiang.js'

// register globally
Vue.component('multiselect', Multiselect);
Vue.component('Sticky', Sticky);
Vue.component('icon-svg', IconSvg);
Vue.use(ElementUI);
Vue.use(vueWaves);
Vue.use(VXEUtils, XEUtils);
Vue.use(BaiduMap, {
  ak: 'gvQPveN9YrlPSgKUMPK2u2u2BA4yQFRm'
})

import infiniteScroll from 'vue-infinite-scroll'
Vue.use(infiniteScroll);

// register global utility filters.
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
});

// register global progress.
const whiteList = ['/login', '/authredirect', '/map', '/stockCrowd', '/stockCrowdDetail', '/companyInfo', '/provinceMap', '/campsite'];// 不重定向白名单
router.beforeEach((to, from, next) => {
  NProgress.start(); // 开启Progress
  if (getToken()) { // 判断是否有token
    if (to.path === '/login') {
      next({ path: '/' });
    } else {
      if (store.getters.menus === undefined) { // 判断当前用户是否已拉取完user_info信息
        store.dispatch('GetInfo').then(info => { // 拉取user_info
          const menus = {};
          for (let i = 0; i < info.menus.length; i++) {
            menus[info.menus[i].code] = true;
          }
          store.dispatch('GenerateRoutes', menus).then(() => { // 生成可访问的路由表
            router.addRoutes(store.getters.addRouters) // 动态添加可访问路由表
            next({ ...to }); // hack方法 确保addRoutes已完成
          })
        }).catch(() => {
          store.dispatch('FedLogOut').then(() => {
            next({ path: '/login' });
          })
        })
      } else {
      //  else {
      //   // 没有动态改变权限的需求可直接next() 删除下方权限判断 ↓
      //   if (hasPermission(store.getters.roles, to.meta.role)) {
      //     next();//
      //   } else {
        next();
      //   }
      //   // 可删 ↑
      }
    }
  } else {
    if (whiteList.indexOf(to.path) !== -1) { // 在免登录白名单，直接进入
      next()
    } else {
      next('/login'); // 否则全部重定向到登录页
      NProgress.done(); // 在hash模式下 改变手动改变hash 重定向回来 不会触发afterEach 暂时hack方案 ps：history模式下无问题，可删除该行！
    }
  }
});

router.afterEach(() => {
  NProgress.done(); // 结束Progress
});

Vue.config.productionTip = false;

// 生产环境错误日志
if (process.env.NODE_ENV === 'production') {
  Vue.config.errorHandler = function(err, vm) {
    console.log(err, window.location.href);
    errLog.pushLog({
      err,
      url: window.location.href,
      vm
    })
  };
}

new Vue({
  el: '#app',
  router,
  store,
  template: '<App/>',
  components: { App }
})
