import fetch from 'utils/fetch';
/**
 * 获取营地标签List
 */
export function campsiteTagList(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/pages',
    method: 'get',
    params: query
  });
}
/**
 * 获取营地全部标签
 * */
export function campsiteAllTagList(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/all',
    method: 'get',
    params: query
  });
}
/**
 * 是否是筛选条件
 * */
export function setSearchById(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/searchStatus?id=' + query.id + '&status=' + query.status,
    method: 'put'
  });
}
/**
 * 删除营地标签
 */
export function delCampsiteTag(id) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/' + id,
    method: 'delete'
  });
}
/**
 * 编辑营地标签
 * */
export function editCampsiteTag(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/' + query.id,
    method: 'put',
    data: query
  });
}
/**
 * 创建营地标签
 * */
export function addCampsiteTag(params) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag',
    method: 'post',
    data: params
  });
}
/**
 * 判断标签是否已存在
 * @param id
 */
export function existTag(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteTag/exist',
    method: 'get',
    params: query
  });
}
/**
 * 获取营地List
 */
export function getCampsiteList(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/pages',
    method: 'post',
    data: query
  });
}
/**
 * 删除营地列表数据
 */
export function delCampsiteShop(id) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/' + id,
    method: 'delete'
  });
}

/**
 * 根据id获取一条营地列表数据
 */
export function getOneCampsiteShop(id) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/campsite/' + id,
    method: 'get'
  });
}
/**
 * 编辑营地数据
 * */
export function editCampsiteShop(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/save',
    method: 'post',
    data: query
  });
}
/**
 * 创建营地
 * */
export function addCampsiteShop(params) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/save',
    method: 'post',
    data: params
  });
}

/**
 * 判断营地名称是否已存在
 * @param id
 */
export function existCampsiteShop(query) {
  return fetch({
    url: '/api/campsite/admin/campsiteShop/exist',
    method: 'get',
    params: query
  });
}

/**
 * 获取旅游标签List
 */
export function tourTagAdd(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/save',
    method: 'post',
    data: query
  });
}
/**
 *热门标签状态
 */
export function tourTagHot(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/update/hot',
    method: 'put',
    params: query
  });
}

/**
 *删除旅游标签
 */
export function deleteTourTag(id) {
  return fetch({
    url: '/api/tour/admin/tourTag/' + id,
    method: 'delete'
  });
}

/**
 * 获取全部旅游标签
 * @param query
 */
export function getAllTourTag(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/tags',
    method: 'get',
    params: query
  });
}
/**
 * 获取全部旅游标签
 * @param query
 */
export function goodDel(id) {
  return fetch({
    url: '/api/tour/good/admin/goodDel/' + id,
    method: 'get'
  });
}
/**
 * 上架、下架
 * */
export function upStatusChange(query) {
  return fetch({
    url: '/api/tour/good/admin/upStatus',
    method: 'get',
    params: query
  });
}
