import fetch from 'utils/fetch';

/**
 * 获取车型列表
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/vehicle/vehicleModel/app/findVehicleModelPage',
    method: 'post',
    data: query
  });
}
/**
 * 根据车型id获取车型详情
 */
export function getOneTypeById(id) {
  return fetch({
    url: '/vehicle/vehicleModel/' + id,
    method: 'get'
  });
}

/**
 * 获取全部一级标签
 */
export function getAllParentLabel() {
  return fetch({
    url: '/vehicle/cata/add/fingCatasByParentId/' + 0,
    method: 'get'
  });
}

/**
 * 根据parentId获取子标签
 */
export function getLabelByParentId(id) {
  return fetch({
    url: '/vehicle/cata/add/fingCatasByParentId/' + id,
    method: 'get'
  });
}

/**
 * 获取标签列表
 */
// 0-不分页,1-分页(标签列表)
export function getLabelList(query) {
  return fetch({
    url: '/vehicle/cata/add/getCascades/' + query.page + '/' + query.limit + '/' + query.sort,
    method: 'get'
  });
}
/**
 * 删除车型标签deleteVehicleType
 */
export function deleteVehicleType(id) {
  return fetch({
    url: '/vehicle/cata/add/deleteCascadeById/' + id,
    method: 'delete'
  });
}

/**
 * 获取全部车型
 * */
export function getAllVehicleList() {
  return fetch({
    url: '/vehicle/vehicleModel/findAll',
    method: 'get'
  });
}
/**
 * 车型标签是否多选
 */
export function setIsMoreById(query) {
  return fetch({
    url: '/vehicle/cata/add/setIsMore/' + query.id + '/' + query.isMore,
    method: 'put'
  });
}
/**
 * 是否是筛选条件
 * */
export function setStartUsingById(query) {
  return fetch({
    url: '/vehicle/cata/add/setStartUsingById/' + query.id + '/' + query.startUsing,
    method: 'put'
  });
}

/**
 * 修改标签排序
 */
export function updateParentRank(query) {
  return fetch({
    url: '/vehicle/cata/add/updateParentRank/' + query.id + '/' + query.rank,
    method: 'put'
  });
}

/**
 * 修改和增加一二级标签
 * */
export function updateAndAdd(params) {
  return fetch({
    url: '/vehicle/cata/add/updateAndAdd',
    method: 'post',
    data: params
  });
}

/**
 * 编辑一条车型数据
 * */
export function updateVehicleModel(params) {
  return fetch({
    url: '/vehicle/vehicleModel/app/update',
    method: 'put',
    data: params
  });
}

/*
* 新建一条车型数据
* */
export function addVehicleModel(params) {
  return fetch({
    url: '/vehicle/vehicleModel/app/add',
    method: 'post',
    data: params
  });
}

/*
* 删除一条车型数据
* */
export function delVehicleModel(id) {
  return fetch({
    url: '/vehicle/vehicleModel/app/' + id,
    method: 'delete'
  });
}
