import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/tour/good/admin/goodList',
    method: 'post',
    data: query
  });
}
/**
 * 编辑、新建旅游路线
 * @param query
 */
export function goodsEdit(query) {
  return fetch({
    url: '/api/tour/good/admin/goodEdit',
    method: 'post',
    data: query
  });
}

/**
 * 根据旅游id获取旅游详情
 */
export function getOneGoodsById(query) {
  return fetch({
    url: '/api/tour/good/admin/goodOne',
    method: 'get',
    params: query
  });
}
/**
 * 获取bannerList
 // url: '/api/tour/admin/tourBanner/page',
 */
export function getBannerList(query) {
  return fetch({
    url: '/api/app/admin/banner/page',
    method: 'get',
    params: query
  });
}
/**
 * 添加banner  '/api/tour/admin/tourBanner',
 */
export function addBanner(params) {
  return fetch({
    url: '/api/app/admin/banner/page',
    method: 'post',
    data: params
  });
}
/**
 * 修改banner
 */
export function editBanner(params) {
  return fetch({
    url: '/api/app/admin/banner',
    method: 'put',
    data: params
  });
}

// delBanner
/**
 * 删除banner
 */
export function delBanner(id) {
  return fetch({
    url: '/api/app/admin/banner' + id,
    method: 'delete'
  });
}

/**
 * 获取旅游标签List
 */
export function getTourTagList(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/pages',
    method: 'get',
    params: query
  });
}
/**
 * 获取旅游标签List
 */
export function tourTagUpdate(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/update',
    method: 'put',
    data: query
  });
}

/**
 * 获取旅游标签List
 */
export function tourTagAdd(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/save',
    method: 'post',
    data: query
  });
}
/**
 *热门标签状态
 */
export function tourTagHot(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/update/hot',
    method: 'put',
    params: query
  });
}

/**
 *删除旅游标签
 */
export function deleteTourTag(id) {
  return fetch({
    url: '/api/tour/admin/tourTag/' + id,
    method: 'delete'
  });
}

/**
 * 判断标签是否已存在
 * @param id
 */
export function existTourTag(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/exist',
    method: 'get',
    params: query
  });
}

/**
 * 获取全部旅游标签
 * @param query
 */
export function getAllTourTag(query) {
  return fetch({
    url: '/api/tour/admin/tourTag/tags',
    method: 'get',
    params: query
  });
}
/**
 * 获取全部旅游标签
 * @param query
 */
export function goodDel(id) {
  return fetch({
    url: '/api/tour/good/admin/goodDel/' + id,
    method: 'get'
  });
}
/**
 * 上架、下架
 * */
export function upStatusChange(query) {
  return fetch({
    url: '/api/tour/good/admin/upStatus',
    method: 'get',
    params: query
  });
}
