import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/page',
    method: 'get',
    params: {vehiclePageQueryVoJson: query}
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/' + id,
    method: 'get'
  });
}


export function addObj(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo',
    method: 'post',
    data: [obj]
  });
}

export function book(param) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee',
    method: 'post',
    data: param
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo',
    method: 'put',
    data: [obj]
  })
}

export function getBookedInfoIn2Month(vehicleId) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedInfo/' + vehicleId,
    method: 'get'
  });
}

export function getBookedInfo(vehicleId, yearMonth) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedInfo/' + vehicleId + '/' + yearMonth,
    method: 'get'
  });
}
