import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/member/info/all',
    method: 'get',
    params: query
  });
}

export function addObj(obj) {
  return fetch({
    url: '/api/member/info',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/member/info/' + id,
    method: 'get'
  })
}

export function delObj(id) {
  return fetch({
    url: '/api/member/info/' + id,
    method: 'delete'
  })
}

export function putObj(obj) {
  return fetch({
    url: '/api/member/info',
    method: 'put',
    data: obj
  })
}
