import store from "../../../store";
import XEUtils from 'xe-utils';//加入常用工具类
import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/vehicle/branchCompany/page',
    method: 'get',
    params: query
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'get'
  });
}


export function addObj(obj) {
  return fetch({
    url: '/vehicle/branchCompany/',
    method: 'post',
    data: obj
  });
}
// 股权价格
export function getAllStockPrice() {
  return fetch({
    url: '/vehicle/branchCompany/stock/allPrice',
    method: 'get'
  });
}

// 我要参与-众筹
export function stockApply(obj) {
  return fetch({
    url: 'vehicle/branchCompany/stock/apply',
    method: 'post',
    data: obj
  });
}
// 股权列表
export function stockSearchPage(query) {
  return fetch({
    url: '/vehicle/branchCompany/stock/search',
    method: 'get',
    params: query
  });
}


export function delObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'delete'
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'put',
    data: obj
  })
}

export function getAll() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  })
}

/**
 * 获取所有公司信息
 * @returns {null|*}
 */
export function getAllCompany(resolve) {
    getAll().then(response => {
      let companyList = response.data;
      if (!companyList || companyList.length === 0) {
        return null;
      }
      let codeAndBranchCompany = {};
      for (let index in companyList) {
        codeAndBranchCompany[companyList[index].id] = companyList[index];
      }
      resolve(codeAndBranchCompany);
    });
}
