import fetch from 'utils/fetch';

/**
 * 获取列表
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/api/uccn/article/all',
    method: 'post',
    data:query
  });
}

/**
 * 添加
 * @param query
 */
export function add(query) {
  return fetch({
    url: '/api/uccn/article/add',
    method: 'post',
    data:query
  });
}

/**
 * 删除
 * @param query
 */
export function update(query) {
  return fetch({
    url: '/api/uccn/article/update',
    method: 'put',
    data:query
  });
}


/**
 * 上架
 * @param id
 */
export function putaway(id) {
  return fetch({
    url: '/api/uccn/article/putaway/'+id,
    method: 'put'
  });
}

/**
 * 下架
 * @param query
 */
export function soldOut(id) {
  return fetch({
    url: '/api/uccn/article/soldOut/'+id,
    method: 'put',

  });
}

/**
 * 删除
 * @param id
 */
export function remove(id) {
  return fetch({
    url: '/api/uccn/article/remove/'+id,
    method: 'put'
  });
}

/**
 * 查询一条
 * @param query
 */
export function getOne(query) {
  return fetch({
    url: '/api/uccn/article/app/unauth/one',
    method: 'get',
    params:query
  });
}
