import fetch from 'utils/fetch';

export function appPage(obj) {
  return fetch({
    url: '/api/admin/appUsersManage/findAll',
    method: 'post',
    data: obj
  });
}

export function getObj(id) {
  return fetch({
    url: '/api/admin/appUsersManage/findOneById/'+id,
    method: 'get',
  });
}


export function setAvailable(id) {
  return fetch({
    url: '/api/admin/appUsersManage/available/'+id,
    method: 'put',
  });
}

export function setDisable(id) {
  return fetch({
    url: '/api/admin/appUsersManage/disable/'+id,
    method: 'put',
  });
}

export function seveObj(obj) {
  return fetch({
    url: '/api/admin/baseUserMember/setUserMember',
    method: 'put',
    data:obj
  });
}
/**
 * 会员录入-列表
 * */
export function getMemberEntryList(query) {
  return fetch({
    url: '/api/admin/admin/member/page',
    method: 'get',
    params: query
  });
}

/**
 * 会员录入-删除
 */
export function delMemberObj(id) {
  return fetch({
    url: '/api/admin/admin/member/' + id,
    method: 'delete'
  });
}


/**
 * 用户列表-删除
 * @param id
 */
export function deleteUser(id) {
  return fetch({
    url: '/api/admin/appUsersManage/deleteById/' + id,
    method: 'delete'
  });
}

/**
 * 身份设置
 * @param obj
 */
export function userPosition(obj) {
  return fetch({
    url: '/api/admin/appUsersManage/user_position?id='+obj.id+'&positionId='+obj.positionId,
    method: 'put',
  });
}